% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitAsBumpyMatrix.R
\name{splitAsBumpyMatrix}
\alias{splitAsBumpyMatrix}
\title{Split to a BumpyMatrix}
\usage{
splitAsBumpyMatrix(x, row, column, sparse = FALSE)
}
\arguments{
\item{x}{A vector or \linkS4class{Vector} object, most typically a \linkS4class{DFrame}.}

\item{row}{An object coercible into a factor, of length equal to \code{x}.
This defines the row index for each element of \code{x}.}

\item{column}{An object coercible into a factor, of length equal to \code{x}.
This defines the column index for each element of \code{x}.}

\item{sparse}{Logical scalar indicating whether a sparse representation should be used.}
}
\value{
A \linkS4class{BumpyMatrix} of the appropriate type,
with number of rows and columns equal to the number of levels in \code{row} and \code{column} respectively.
Each entry of the matrix contains all elements of \code{x} with the corresponding indices in \code{row} and \code{column}.
}
\description{
Split a vector or \linkS4class{Vector} into a BumpyMatrix based on row/column factors.
This facilitates the construction of a BumpyMatrix from vector-like objects.
}
\examples{
mat <- splitAsBumpyMatrix(runif(1000), 
   row=sample(LETTERS, 1000, replace=TRUE),
   column=sample(10, 1000, replace=TRUE)
)
mat
mat[,1]
mat[1,]

# Or with a sparse representation.
mat <- splitAsBumpyMatrix(runif(10), 
   row=sample(LETTERS, 10, replace=TRUE),
   column=sample(10, 10, replace=TRUE)
)
mat
mat[,1]
mat[1,]

}
\seealso{
\code{\link{BumpyMatrix}}, if a \linkS4class{CompressedList} has already been constructed.

\code{\link{unsplitAsDataFrame}}, which reverses this operation to recover a long-format DataFrame.

\code{\link{splitAsList}}, which inspired this function.
}
\author{
Aaron Lun
}
