% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AtomicMatrix.R
\name{BumpyAtomicMatrix}
\alias{BumpyAtomicMatrix}
\alias{BumpyAtomicMatrix-class}
\alias{show,BumpyAtomicMatrix-method}
\alias{BumpyIntegerMatrix-class}
\alias{BumpyCharacterMatrix-class}
\alias{BumpyNumericMatrix-class}
\alias{BumpyLogicalMatrix-class}
\alias{Ops,BumpyAtomicMatrix,BumpyAtomicMatrix-method}
\alias{Ops,atomic,BumpyAtomicMatrix-method}
\alias{Ops,BumpyAtomicMatrix,atomic-method}
\alias{Ops,matrix,BumpyAtomicMatrix-method}
\alias{Ops,BumpyAtomicMatrix,matrix-method}
\alias{Ops,BumpyAtomicMatrix,missing-method}
\alias{!,BumpyAtomicMatrix-method}
\alias{Math,BumpyAtomicMatrix-method}
\alias{Math2,BumpyAtomicMatrix-method}
\alias{Summary,BumpyAtomicMatrix-method}
\alias{range,BumpyAtomicMatrix-method}
\alias{mean,BumpyAtomicMatrix-method}
\alias{sd,BumpyAtomicMatrix-method}
\alias{median,BumpyAtomicMatrix-method}
\alias{mad,BumpyAtomicMatrix-method}
\alias{var,BumpyAtomicMatrix,missing-method}
\alias{IQR,BumpyAtomicMatrix-method}
\alias{which.min,BumpyAtomicMatrix-method}
\alias{which.max,BumpyAtomicMatrix-method}
\alias{pmin,BumpyAtomicMatrix-method}
\alias{pmax,BumpyAtomicMatrix-method}
\alias{pmin.int,BumpyAtomicMatrix-method}
\alias{pmax.int,BumpyAtomicMatrix-method}
\alias{var,BumpyAtomicMatrix,BumpyAtomicMatrix-method}
\alias{cov,BumpyAtomicMatrix,BumpyAtomicMatrix-method}
\alias{cor,BumpyAtomicMatrix,BumpyAtomicMatrix-method}
\alias{quantile,BumpyAtomicMatrix-method}
\alias{unstrsplit,BumpyCharacterMatrix-method}
\alias{nchar,BumpyCharacterMatrix-method}
\alias{substring,BumpyCharacterMatrix-method}
\alias{substr,BumpyCharacterMatrix-method}
\alias{chartr,ANY,ANY,BumpyCharacterMatrix-method}
\alias{toupper,BumpyCharacterMatrix-method}
\alias{tolower,BumpyCharacterMatrix-method}
\alias{sub,ANY,ANY,BumpyCharacterMatrix-method}
\alias{gsub,ANY,ANY,BumpyCharacterMatrix-method}
\alias{grep,ANY,BumpyCharacterMatrix-method}
\alias{grepl,ANY,BumpyCharacterMatrix-method}
\alias{startsWith,BumpyCharacterMatrix-method}
\alias{endsWith,BumpyCharacterMatrix-method}
\title{The BumpyAtomicMatrix subclass}
\description{
A subclass of the \linkS4class{BumpyMatrix} where each entry is an atomic vector.
One subclass is provided for each of the most common types.
}
\details{
In the following code snippets, \code{x} is a BumpyDFrameMatrix.

Binary and unary operations are implemented by specializing \link{Ops}, \link{Math} and related group generics,
and will usually return a new BumpyAtomicMatrix of the appropriate type.
The exception is for \link{Summary} methods like \code{max} and \code{min};
these return an ordinary matrix where each entry contains a scalar value for the corresponding entry of \code{x}.
Furthermore, \code{range} will return a 3-dimensional array containing the minimum and maximum for each entry of \code{x}.

Common mathematical operations are implemented that apply to each entry of the BumpyAtomicMatrix:
\itemize{
\item \code{mean}, \code{sd}, \code{median}, \code{mad}, \code{var} and \code{IQR} take a single BumpyAtomicMatrix
and return an ordinary double-precision matrix of the same dimensions containing the computed statistic for each entry of the input.
This is possible as all operations are guaranteed to produce a scalar.
\item \code{quantile} takes a single BumpyAtomicMatrix as input and return a 3-dimensional array.
The first dimension contains the requested quantiles, the second dimension corresponds to the rows of \code{x} 
and the third dimension corresponds to the columns of \code{x}.
\item \code{which.max} and \code{which.min} take a single BumpyAtomicMatrix
and return an ordinary integer matrix of the same dimensions containing the index for the min/max value per entry.
(This is set to \code{NA} if the entry of the input has length zero.)
\item \code{pmin}, \code{pmax}, \code{pmin.int} and \code{pmax.int} take multiple BumpyAtomicMatrix objects of the same dimensions,
and return a BumpyAtomicMatrix containing the result of running the same function across corresponding entries of the input objects.
\item \code{cor}, \code{cov} and (optionally) \code{var} take two BumpyAtomicMatrix objects of the same dimensions,
and return an ordinary matrix containing the computed statistic for the corresponding entries of the inputs. 
This is possible as all operations are guaranteed to produce a scalar.
}

Additionally, common operations are implemented that apply to each entry of the BumpyCharacterMatrix
and return a BumpyAtomicMatrix of the same dimensions and an appropriate type.
This includes \code{tolower}, \code{toupper}, \code{substr}, \code{substring}, \code{sub}, \code{gsub}, \code{grepl}, \code{grep},
\code{nchar}, \code{chartr}, \code{startsWith} and \code{endsWith}.
We also implement \code{unstrsplit}, which returns an ordinary matrix of the same dimensions containing the unsplit strings.

All methods implemented for the \linkS4class{BumpyMatrix} parent class are available here.
}
\examples{
# Mocking up a BumpyNumericList:
library(IRanges)
x <- splitAsList(runif(1000), factor(sample(50, 1000, replace=TRUE), 1:50))  

# Creating a BumpyNumericMatrix:
mat <- BumpyMatrix(x, c(10, 5))
mat[,1]

# Arithmetic operations:
(mat * 2)[,1]
(mat + mat * 5)[,1]

# Logical operations:
(mat < 0.5)[,1]
(mat > 0.5 & mat < 1)[,1]
(mat == mat)[,1]

# More statistics:
max(mat)
min(mat)
mean(mat)
sd(mat)
median(mat)

# Handling character vectors:
x <- splitAsList(sample(LETTERS, 100, replace=TRUE), 
    factor(sample(20, 100, replace=TRUE), 1:20))
cmat <- BumpyMatrix(x, c(5, 4))
cmat[,1]

tolower(cmat[,1])
grepl("A|E|I|O|U", cmat)[,1]
sub("A|E|I|O|U", "vowel", cmat)[,1]

}
