% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{.customheatmap}
\alias{.customheatmap}
\title{Heatmap function for gene signature expression}
\usage{
.customheatmap(
  counts,
  name,
  fontsize = 6,
  col.fontsize = 6,
  legend.fontsize = 8,
  annot.fontsize = 8,
  h.height = 3,
  scoring = NULL,
  cols.scoring = NULL,
  hcl.palette = "Blues 3",
  show_column_names = FALSE
)
}
\arguments{
\item{counts}{Matrix of counts.}

\item{name}{Name of the heatmap to generate.}

\item{fontsize}{Font size for row (gene) names.}

\item{col.fontsize}{Font size for column (sample) names.}

\item{legend.fontsize}{Font size for the legends.}

\item{annot.fontsize}{Font size for column annotation names.}

\item{h.height}{Heatmap  height in cm.}

\item{scoring}{Vector of sample scores for a
chosen pathway. If NULL, then no column annotation is produced.}

\item{cols.scoring}{Fixed colorRamp2 object.}

\item{hcl.palette}{Palette from
HCL colormaps supported by ComplexHeatmap.}
}
\value{
A ComplexHeatmap object.

This is a convenience function that relies
on the \code{ComplexHeatmap}
package.
}
\description{
Generate one heatmap used by
\code{signatureHeatmaps}.
}
\keyword{internal}
