% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource.R
\name{resetNetwork}
\alias{resetNetwork}
\title{Import a refernce network of your own}
\usage{
resetNetwork(network)
}
\arguments{
\item{network}{Network data frame made of 3 columns
a.gn, b.gn & type. 'a.gn' & 'b.gn' should be gene symbols
of gene interactions. 'type'  should be set as
'controls-expression-of' when a user provides
his own file.}
}
\value{
Returns `NULL`, invisibly.
}
\description{
Network is a data frame that defines interactions between
genes. It's composed of 3 columns named as
follows:
}
\details{
a.gn: Gene Symbol 1
type: controls-expression-of
b.gn: Gene Symbol 2

When the user provides his own network,
'type' should be set to 'controls-expression-of'.
}
\examples{
 BulkSignalR_Network <- getResource(resourceName = "Network",
 cache = FALSE)
resetNetwork(BulkSignalR_Network)
}
