% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridplot.R
\name{gridplot}
\alias{gridplot}
\title{Fingerprint grid visualization}
\usage{
gridplot(Group_df, cutoff = NULL, Ref_group = NULL, filename = NULL)
}
\arguments{
\item{Group_df}{Dataframe with output generated after running the'Groupcomparison' function}

\item{cutoff}{Numeric value specifying the percentage cut off used for fingerprint visualization (from 0 to 100)}

\item{Ref_group}{Character vector specifying value within the group column that will be used as Reference group}

\item{filename}{Character vector with a name for saving file}
}
\value{
\preformatted{       A pdf file of grid plot
}
}
\description{
The gridplot function will generate a grid plot as a pdf file. Specific working directory for the analysis need to be specified for saving the file. The result of the plot should be return in the same working directory.
The default cut off for visualization is set at 15\%, it can be changed to any value between 0-100\%.
}
\examples{
## data could be downloaded from ExperimentHub("GSE13015")
library(ExperimentHub)
library(SummarizedExperiment)
dat = ExperimentHub()
res = query(dat , "GSE13015")
GSE13015 = res[["EH5429"]]
Group_df = Groupcomparison(GSE13015, sample_info = NULL,
                          FC = 0, pval = 0.1, FDR = TRUE, Test_group = "Sepsis",
                          Group_column = "Group_test", Ref_group = "Control")
gridplot(Group_df, cutoff = 15,
         Ref_group = "Control",
         filename= tempfile())
}
\author{
Darawan Rinchai \href{mailto:drinchai@gmail.com}{drinchai@gmail.com}
}
