% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Groupcomparison.R
\name{Groupcomparison}
\alias{Groupcomparison}
\title{Group comparison analysis}
\usage{
Groupcomparison(
  data.matrix,
  sample_info = NULL,
  FC = NULL,
  pval = NULL,
  FDR = TRUE,
  Group_column = NULL,
  Test_group = "Test_group",
  Ref_group = "Control",
  SummarizedExperiment = TRUE
)
}
\arguments{
\item{data.matrix}{Matrix of normalized expression data (not Log2 transformed).Row names are required to be valid Gene Symbols. Columns names are sample IDs
or data.matrix can also be given a summarizedexperiment object and assigned data.matrix and sample_info accordingly from the object.}

\item{sample_info}{A dataframe with sample annotation. Sample_info dataframe requires two columns: 1) a column specifying Sample ID (exactly matching the Sample ID of data.matrix)
and 2) a column specifying group names}

\item{FC}{Numeric value specifying the foldchange cut off that will be applied to define increase or decrease of a given transcript compared to the reference group}

\item{pval}{Numeric value specifying p-value cut off or False discovery rate    when FDR = TRUE}

\item{FDR}{Logical operator to specify whether False discovery rate cut off (using BH-method) should be used}

\item{Group_column}{Character vector identical to the column name from sample_info dataframe that specifies group annotation used for the analysis}

\item{Test_group}{Character vector specifying values within the group column (Group_column) that will be used as Test group (samples considered as cases or “intervention” group).}

\item{Ref_group}{Character vector specifying value within the group column (Group_column) that will be used as Reference group}

\item{SummarizedExperiment}{Output data as the SummarizedExperiment class when SummarizedExperiment = TRUE}
}
\value{
\preformatted{            A matrix of the percentahe of module response in each group comparison
}
}
\description{
The Groupcomparison function will perform group comparison analyses and the results are expressed “at the module level” as percent of genes increased or decreased.
\itemize{
\item Expression matrix and sample annotation files are required to perform this analysis.
\item The sample annotation file must be loaded using a specific name = "sample_info".
\item The names of the columns for the conditions used in the analysis must be specified.
}
}
\examples{
## data could be downloaded from ExperimentHub("GSE13015")
library(ExperimentHub)
library(SummarizedExperiment)
dat = ExperimentHub()
res = query(dat , "GSE13015")
GSE13015 = res[["EH5429"]]
Group_df = Groupcomparison(GSE13015, sample_info = NULL,
                          FC = 0, pval = 0.1, FDR = TRUE, Test_group = "Sepsis",
                          Group_column = "Group_test", Ref_group = "Control")
}
\author{
Darawan Rinchai \href{mailto:drinchai@gmail.com}{drinchai@gmail.com}
}
