% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5mat.R
\name{H5matref}
\alias{H5matref}
\title{obtain an HDF5 dataset reference suitable for handling as numpy matrix}
\usage{
H5matref(filename, dsname = "assay001")
}
\arguments{
\item{filename}{a pathname to an HDF5 file}

\item{dsname}{internal name of HDF5 matrix to use, defaults to 'assay001'}
}
\value{
instance of (S3) "h5py._hl.dataset.Dataset"
}
\description{
obtain an HDF5 dataset reference suitable for handling as numpy matrix
}
\note{
This should only be used with persistent environment discipline of basilisk.
Additional support is planned in Bioc 3.12.
}
\examples{
fn = system.file("ban_6_17/assays.h5", package="BiocSklearn")
ban = H5matref(fn)
ban
proc = basilisk::basiliskStart(BiocSklearn:::bsklenv)
fullpca = basilisk::basiliskRun(proc, function() {
 np = import("numpy", convert=FALSE) # ensure
 print(ban$shape)
 print(np$take(ban, 0:3, 0L))
 fullpca = skPCA(ban)
 tx = getTransformed(fullpca)
 print(dim(tx))
 fullpca
 })
basilisk::basiliskStop(proc)
# project samples
np = reticulate::import("numpy", convert=FALSE, delay_load=TRUE)
np$take(ban, 0:20, 0L)$shape
st = skPartialPCA_step(np$take(ban, 0:20, 0L), n_comp=4L)
st = skPartialPCA_step(np$take(ban, 21:40, 0L), n_comp=4L, obj=st)
st = skPartialPCA_step(np$take(ban, 41:63, 0L), n_comp=4L, obj=st)
oo = st$transform(ban)
dim(oo)
cor(oo[,1:4], getTransformed(fullpca)[,1:4])
}
