% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementset_funs.R
\name{elementset_funs}
\alias{elementset_funs}
\alias{filter_elementset}
\alias{select_elementset}
\alias{mutate_elementset}
\alias{summarise_elementset}
\alias{arrange_elementset}
\alias{left_join_elementset}
\alias{tibble_from_elementset}
\alias{data.frame_from_elementset}
\title{Functions applied to elementsets in a \code{BiocSet} object}
\usage{
filter_elementset(.data, ...)

select_elementset(.data, ...)

mutate_elementset(.data, ...)

summarise_elementset(.data, ...)

arrange_elementset(.data, ...)

left_join_elementset(.data, ...)

tibble_from_elementset(.data)

data.frame_from_elementset(.data)
}
\arguments{
\item{.data}{A \code{BiocSet} object.}

\item{...}{Additional arguments passed to the function.}
}
\value{
A \code{BiocSet} object.

For \code{tibble_from_elementset}, a tibble.

For \code{data.frame_from_elementset}, a data.frame.
}
\description{
All of the major methods applied to a \code{BiocSet} object can
    be explicitly applied to the elementset tibble. These functions bypass 
    the need to use the \code{es_activate} function by indicating what 
    function should be used on the elementset tibble.
}
\examples{
es <- BiocSet(set1 = letters, set2 = LETTERS)
filter_elementset(es, element == "a" | element == "A")

es \%>\% select_elementset(element)

es \%>\% mutate_elementset(pval = rnorm(1:52))

es \%>\% summarise_elementset(n = n())

es \%>\% arrange_elementset(desc(element))

tbl <- tibble(x = 5:6, y = c("set1", "set2"))
es \%>\% left_join_elementset(tbl, by = c(set = "y"))

tibble_from_elementset(es)

data.frame_from_elementset(es)
}
