% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getYearsInBioc.R
\name{getPkgYearsInBioc}
\alias{getPkgYearsInBioc}
\title{Calculate the years in Bioconductor}
\usage{
getPkgYearsInBioc(pkglist = NULL)
}
\arguments{
\item{pkglist}{List of packages to retrieve information. If default NULL,
returns a tibble of all Bioconductor packages.}
}
\value{
'tibble' with the following columns:
\itemize{
\item package: name of Bioconductor package
\item category: bioc, data/experiment, data/annotation, workflow
\item first_version_available: Bioconductor version (e.g. 1.9, 3.21) the
package first became available
\item first_version_release_date: Equivalent calendar date of given
Bioconductor release
\item approx_years_in: Numeric indicator of years in Bioconductor. If empty,
indicates package was removed. See final three columns for more
information.
\item last_version_available: If package was removed from Bioconductor, the
last Bioconductor version (e.g. 1.9, 3.21) the package was able to be
installed
\item last_version_release_date: Equivalent calendar date of given Bioconductor
release
\item years_before_rm: If removed, how many years it was in Bioconductor
}
}
\description{
This function determines the number of years a package has been
in Bioconductor. Available information includes first Bioconductor version
a package appeared and the current length of time in Bioconductor. If a
package has been removed from Bioconductor, information on the last
Bioconductor version and approximate time in Bioconductor before removal is
available.
}
\examples{
\dontrun{
   ## full table all Bioconductor packages
   tbl <- getPkgYearsInBioc()

   ## example of package list. Packages active in Bioconductor
   tbl <- getPkgYearsInBioc(c("BiocFileCache", "BiocPkgTools"))

   ## example of a package that has been removed from Bioconductor
   tbl <- getPkgYearsInBioc("ensemblVEP")
}

}
\author{
Lori Shepherd Kern, Robert Shear
}
