% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocDownloadStats.R
\name{pkgDownloadStats}
\alias{pkgDownloadStats}
\title{Get Bioconductor download statistics for a package}
\usage{
pkgDownloadStats(
  pkg,
  pkgType = c("software", "data-experiment", "workflows", "data-annotation"),
  years = format(Sys.time(), "\%Y")
)
}
\arguments{
\item{pkg}{\code{character(1)} The name of a Bioconductor package}

\item{pkgType}{\code{character(1)} One of 'software', 'data-experiment',
'workflows', or 'data-annotation' (defaults to 'software')}

\item{years}{numeric(), \code{character()} A vector of years from which to
obtain download statistics (defaults to current year)}
}
\value{
A \code{tibble} of download statistics
}
\description{
Get Bioconductor download statistics for a package
}
\examples{

pkgDownloadStats("GenomicRanges")

}
