% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GFF-coercion.R
\name{asGFF}
\alias{asGFF}
\alias{asGFF,GRangesList-method}
\title{Coerce to GFF structure}
\usage{
asGFF(x, ...)

\S4method{asGFF}{GRangesList}(x, parentType = "mRNA", childType = "exon")
}
\arguments{
\item{x}{Generally, a tabular object to structure as GFF(3)}

\item{\dots}{Arguments to pass to methods}

\item{parentType}{The value to store in the \code{type} column for the
top-level (e.g., transcript) ranges.}

\item{childType}{The value to store in the \code{type} column for the child
(e.g., exon) ranges.}
}
\value{
For the \code{GRangesList} method: A \code{GRanges}, with the columns: \code{ID}
(unique identifier), \code{Name} (from \code{names(x)}, and the names on each
element of \code{x}, if any), \code{type} (as given by \code{parentType} and \code{childType}),
and \code{Parent} (to relate each child range to its parent at the top-level).
}
\description{
Coerce the structure of an object to one following GFF-like
conventions, i.e., using the \code{Parent} GFF3 attribute to encode the
hierarchical structure. This object is then suitable for export as GFF3.
}
\section{Methods (by class)}{
\itemize{
\item \code{asGFF(GRangesList)}: Coerce to GFF GRanges structure

}}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(GenomicFeatures)
exons <- exonsBy(TxDb.Hsapiens.UCSC.hg19.knownGene)
mcols(asGFF(exons))
}
\author{
Michael Lawrence
}
