% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{getMaxMCImember}
\alias{getMaxMCImember}
\title{Identifying the 'Biomodule'}
\usage{
getMaxMCImember(membersL, MCIl, minsize = 1)
}
\arguments{
\item{membersL}{A list of integer vectors with unique ids as names. Each
vector represents the cluster number assign to that unique id. The length
of this list is equal to the number of states in the study. This can be the
first element of the output from function \code{getMCI} or the output from
\code{getCluster_methods}, see Examples for more detail.}

\item{MCIl}{A list of numeric vectors with unique cluster numbers as names.
Each vector represents the MCI scores of that module. This can be the
second element of the output from function \code{getMCI}.}

\item{minsize}{A numerical value of the minimum module size (the number of
transcripts in a cluster) to output for downstream analysis.}
}
\value{
A nested list whose length is the length of the input object
\code{membersL}.  Each internal list contains two objects: one object is
the vector of biomodule IDs across states, and the other object is a list of
transcript IDs (each defines the biomodule per state) across states.
}
\description{
This function reports the 'biomodule', which is the module with
the maximum Module Critical Index (MCI) scores for each state. Each state
can have multiple modules (groups of subnetworks derived from the function
\code{\link{getCluster_methods}}). This function runs over all states.
}
\examples{
#1st option: get the input directly from getMCI function
test = list('state1' = matrix(sample(1:10, 6), 4, 3),  
     'state2' = matrix(sample(1:10, 6), 4, 3), 
     'state3' = matrix(sample(1:10, 6), 4, 3))

# assign colnames and rownames to the matrix
for(i in names(test)){
  colnames(test[[i]]) = 1:3
    row.names(test[[i]]) = c('g1', 'g2', 'g3', 'g4')}

cluster = list(c(1, 2, 2, 1), c(1, 2, 3, 1), c(2, 2, 1, 1))
names(cluster) = names(test)
for(i in names(cluster)){
  names(cluster[[i]]) = c('g1', 'g2', 'g3', 'g4')}

membersL_noweight <- getMCI(cluster, test)
maxMCIms <- getMaxMCImember(membersL_noweight[[1]],  membersL_noweight[[2]],  min =3)
#The same as
maxMCIms <- getMaxMCImember(cluster,  membersL_noweight[[2]],  min =2)

## case1: using 'rw' method by default
igraphL <- getNetwork(test,  fdr=1)
cl <- getCluster_methods(igraphL)
## make sure every element in list cl is a \code{communities} object
sapply(cl, class)
##       state1        state2        state3
##"communities" "communities" "communities"

## If there is(are) state(s) that is(are) empty which will not be a communities object(s),  
## please manually remove that state(s).

cl = cl[which(sapply(cl, class) == 'communities')]

## and then run
library(igraph)
cluster = lapply(cl,  membership)
maxCIms <- getMaxMCImember(cluster,  membersL_noweight[[2]],  min =2)

## or run function 'getMCI' and use the 1st option
membersL_noweight <- getMCI(cl, test)

## case2: using methods other than the default
cl <- getCluster_methods(test, method = "pam", cutoff = 2)
## check to make sure membersL_noweight[[2]] has values and run
maxCIms <- getMaxMCImember(cl,  membersL_noweight[[2]],  min =2)

}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}
}
