% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSignedGmt.R
\name{gmtlist2signedGenesets}
\alias{gmtlist2signedGenesets}
\title{Convert gmtlist into a list of signed genesets}
\usage{
gmtlist2signedGenesets(
  gmtlist,
  posPattern = "_UP$",
  negPattern = "_DN$",
  nomatch = c("ignore", "pos", "neg")
)
}
\arguments{
\item{gmtlist}{A gmtlist object, probably read-in by \code{readGmt}}

\item{posPattern}{Regular expression pattern of positive gene sets. It is trimmed from the original name to get the stem name of the gene set. See examples below.}

\item{negPattern}{Regular expression pattern of negative gene sets. It is trimmed from the original name to get the stem name of the gene set. See examples below.}

\item{nomatch}{Options to deal with gene sets that match neither positive nor negative patterns. ignore: they will be ignored (but not discarded, see details below); pos: they will be counted as positive signs; neg: they will be counted as negative signs}
}
\value{
An S4-object of \code{SignedGenesets}, which is a list of signed_geneset, each being a two-item list; the first item is 'pos', containing a character vector of positive genes; and the second item is 'neg', containing a character vector of negative genes.

Gene set names are detected whether they are positive or negative. If neither positive nor negative, nomatch will determine how will they be interpreted. In case of \code{pos} (or \code{neg}), such genesets will be treated as positive (or negative) gene sets.In case nomatch is set to \code{ignore}, the gene set will appear in the returned values with both positive and negative sets set to \code{NULL}.
}
\description{
Convert gmtlist into a list of signed genesets
}
\examples{
testInputList <- list(list(name="GeneSetA_UP",genes=LETTERS[1:3]),
               list(name="GeneSetA_DN", genes=LETTERS[4:6]),
               list(name="GeneSetB", genes=LETTERS[2:4]),
               list(name="GeneSetC_DN", genes=LETTERS[1:3]),
               list(name="GeneSetD_UP", genes=LETTERS[1:3]))
testOutputList.ignore <- gmtlist2signedGenesets(testInputList, nomatch="ignore")
testOutputList.pos <- gmtlist2signedGenesets(testInputList, nomatch="pos")
testOutputList.neg <- gmtlist2signedGenesets(testInputList, nomatch="neg")
}
