% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory_analysis.R
\name{get_HK}
\alias{get_HK}
\title{Get housekeeping genes from global expression profile}
\usage{
get_HK(exp)
}
\arguments{
\item{exp}{A gene expression data frame with genes in row names and
samples in column names or a `SummarizedExperiment` object.}
}
\value{
Character vector of housekeeping gene IDs.
}
\description{
Get housekeeping genes from global expression profile
}
\details{
This function identifies housekeeping genes, which are
broadly expressed genes with low variation in a global scale across samples.
For some cases, users would want to remove these genes as they are not
interesting for coexpression network analyses.
See references for more details.
}
\examples{
data(zma.se)
hk <- get_HK(zma.se)
}
\references{
Machado, F.B., Moharana, K.C., Almeida‐Silva, F., Gazara, R.K.,
Pedrosa‐Silva, F., Coelho, F.S., Grativol, C. and Venancio, T.M. (2020),
Systematic analysis of 1298 RNA‐Seq samples and construction of a
comprehensive soybean (Glycine max) expression atlas. Plant J, 103: 1894-1909.
}
\author{
Fabricio Almeida-Silva
}
