% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sampleGraphClust}
\alias{sampleGraphClust}
\title{Perturbe graph and calculate its clustering}
\usage{
sampleGraphClust(
  gg,
  mask = 20,
  alg,
  type,
  weights = NULL,
  reclust = FALSE,
  Cnmax = 10
)
}
\arguments{
\item{gg}{graph}

\item{mask}{percentage of elements to perturbe}

\item{alg}{clustering alg.}

\item{type}{edges=>1 or nodes=>2  to mask}

\item{weights}{The weights of the edges. It must be a positive numeric
vector, NULL or NA. If it is NULL and the input graph has a ‘weight’
edge attribute, then that attribute will be used. If NULL and no such
attribute is present, then the edges will have equal weights. Set
this to NA if the graph was a ‘weight’ edge attribute, but you don't
want to use it for community detection. A larger edge weight means a
stronger connection for this function. The weights value is ignored
for the \code{spectral} clustering.}

\item{reclust}{logical to decide whether to invoke reclustering via
\code{\link{recluster}}}

\item{Cnmax}{maximum size of the cluster in \code{mem} that will not be
processed if reclustering is invoked}
}
\value{
list of Nx3 matrices
}
\description{
Function will mask \code{mask} a percentage of edges (\code{type=1}) or
vertices (\code{type=2}) from the network, find the largest connected
component of the masked network and cluster it. The clustering results are
stored in a three column matrix: the first column contains the vertex IDs of
input network; the second column the vertex IDs of the subsampled network,
or -1 if the vertex has been masked; the third column the cluster membership
of subsampled network, or -1 if vertex has been masked.
}
\details{
This is internal function and not supposed to be calle by end user.
}
\examples{
data(karate,package='igraphdata')
alg<-'louvain'
mem<-calcMembership(karate,alg = alg)
smpl<-BioNAR:::sampleGraphClust(karate,mask=10,alg,type=2)
}
