% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consMatrix.R
\name{makeConsensusMatrix}
\alias{makeConsensusMatrix}
\title{Function to make random resampling consensus matrix in memory}
\usage{
makeConsensusMatrix(
  gg,
  N = 500,
  mask = 20,
  alg,
  type,
  weights = NULL,
  reclust = FALSE,
  Cnmax = 10
)
}
\arguments{
\item{gg}{graph to perturb}

\item{N}{number of perturbation steps}

\item{mask}{percentage of elements to perturbe}

\item{alg}{clustering alg.}

\item{type}{edges (1) or nodes (2)  to mask}

\item{weights}{The weights of the edges. It must be a positive numeric
vector, NULL or NA. If it is NULL and the input graph has a ‘weight’
edge attribute, then that attribute will be used. If NULL and no such
attribute is present, then the edges will have equal weights. Set
this to NA if the graph was a ‘weight’ edge attribute, but you don't
want to use it for community detection. A larger edge weight means a
stronger connection for this function. The weights value is ignored
for the \code{spectral} clustering.}

\item{reclust}{logical to decide wether to invoke reclustering via
\code{\link{recluster}}}

\item{Cnmax}{maximum size of the cluster in \code{mem} that will not be
processed if reclustering is invoked}
}
\value{
consensus matrix of Nvert X Nvert
}
\description{
Function to make random resampling consensus matrix in memory
}
\details{
Function to assess the robustness of network clustering. A randomisation
study is performed apply the same clustering algorithm to N perturbed
networks, and which returns the consensus matrix where each vertex pair is
assigned the probability of belong to the same cluster. The inputted network
is perturbed by randomly removing a \code{mask} percentage of edges
(\code{type=1}) or vertices (\code{type=2}) from the network before
clustering.
}
\examples{
karate <- make_graph("Zachary")
# We need vertex ID in the 'name' attribute of the vertex
V(karate)$name<-c(LETTERS,letters)[1:vcount(karate)]
alg<-'louvain'
gg<-calcClustering(karate, alg = alg)
conmat<-makeConsensusMatrix(gg, N=100, mask = 10, alg = alg, type = 2)
dim(conmat)
}
\seealso{
Other Robustness Functions: 
\code{\link{getRobustness}()}
}
\concept{Robustness Functions}
