% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCentrality.R
\name{getPA}
\alias{getPA}
\title{Generate random graph from reference}
\usage{
getPA(gg, pwr, ...)
}
\arguments{
\item{gg}{reference graph}

\item{pwr}{the power parameter for the \code{\link[igraph]{sample_pa}}}

\item{...}{additional parameters to be passed to the
\code{\link[igraph]{sample_pa}}}
}
\value{
new instance of the random graph.
}
\description{
The function generates random Barabasi-Albert graph
(\code{\link[igraph]{sample_pa}}) with the same vertex number as in the
reference graph \code{gg} and the power specified by parameter \code{pwr}.
If pwr is missing, we are trying to estimate pwr from the reference
graph \code{gg}.
}
\examples{
data(karate,package='igraphdata')
vcount(karate)
ecount(karate)
rg<- getPA(karate,pwr=1.25)
vcount(rg)
ecount(rg)
}
