% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildNetwork.R
\name{addEdgeAtts}
\alias{addEdgeAtts}
\title{Copy edge attributes from one graph to another}
\usage{
addEdgeAtts(GG, gg)
}
\arguments{
\item{GG}{igraph object, source of attributes}

\item{gg}{igraph object, attributes recipient}
}
\value{
annotated version of \code{gg} igraph object
}
\description{
Copy edge attributes from one graph to another
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.gml", package = "BioNAR")
GG <- igraph::read_graph(file, format="gml")
gg<-findLCC(GG)
gg <- addEdgeAtts(GG, gg)
edge_attr_names(gg)
}
