% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clusteringSummary}
\alias{clusteringSummary}
\title{Matrix of cluster characteristics}
\usage{
clusteringSummary(
  gg,
  att = c("lec", "wt", "fc", "infomap", "louvain", "sgG1", "sgG2", "sgG5", "spectral")
)
}
\arguments{
\item{gg}{graph to analyse}

\item{att}{vector of attribute names that contains membership data}
}
\value{
matrix of clustering characteristics
}
\description{
Function to calculate basic summary statistics after apply clustering
algorithm:
\itemize{
\item N -- number of vertices in the graph \code{\link[igraph]{vcount}}
\item mod -- clustering modularity \code{\link[igraph]{modularity}}, the ratio
of edges found within communities to the number of edges found between
communities, relative to a randomised model
\item C -- number of clusters
\item Cn1 -- number of singletones (clusters of size 1)
\item Cn100 -- number of clusters containing more than 100 nodes
\item mu -- the ratio of edges found within communities to the number of edges
found between communities
\item Min. C -- minimum of the cluster size
\item 1st Qu. C -- first quartile of the cluster size
\item Median C -- median of the cluster size
\item Mean C -- average cluster size
\item 3rd Qu. C  -- third quartile of the cluster size
\item Max. C -- maximum of the cluster size
}
}
\examples{
data(karate,package='igraphdata')
g<-calcAllClustering(karate)
clusteringSummary(g)
}
