% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mclusterGeneSim.R
\name{mclusterGeneSim}
\alias{mclusterGeneSim}
\alias{mclusterGeneSim,list,GeneSetCollection-method}
\title{Similarity score between clusters of genes based on genes similarity}
\usage{
mclusterGeneSim(clusters, info, method = c("max", "rcmax.avg"), ...)

\S4method{mclusterGeneSim}{list,GeneSetCollection}(clusters, info, method = c("max", "rcmax.avg"), ...)
}
\arguments{
\item{clusters}{A list of clusters of genes to be found in \code{id}.}

\item{info}{A GeneSetCollection or a list of genes and the pathways they are
involved.}

\item{method}{A vector with two  or one argument to be passed to
combineScores the first one is used to summarize the similarities of genes,
the second one for clusters.}

\item{...}{Other arguments passed to \code{combineScores}}
}
\value{
Returns a matrix with the similarity scores for each cluster
comparison.
}
\description{
Looks for the similarity between genes of a group and then between each
group's genes.
}
\section{Methods (by class)}{
\itemize{
\item \code{mclusterGeneSim(clusters = list, info = GeneSetCollection)}: Calculates all the similarities of the
GeneSetCollection and combine them using \code{\link[=combineScoresPar]{combineScoresPar()}}

}}
\examples{
if (require("org.Hs.eg.db")) {
    genes.kegg <- as.list(org.Hs.egPATH)
    clusters <- list(
        cluster1 = c("18", "81", "10"),
        cluster2 = c("100", "594", "836"),
        cluster3 = c("18", "10", "83")
    )
    mclusterGeneSim(clusters, genes.kegg)
    mclusterGeneSim(clusters, genes.kegg, c("max", "avg"))
    mclusterGeneSim(clusters, genes.kegg, c("max", "BMA"))
} else {
    warning("You need org.Hs.eg.db package for this example")
}
}
\seealso{
\code{\link[=clusterGeneSim]{clusterGeneSim()}}, \code{\link[=clusterSim]{clusterSim()}} and
\code{\link[=combineScores]{combineScores()}}
}
\author{
Lluís Revilla
}
