% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{subset-BSFDataSet}
\alias{subset-BSFDataSet}
\alias{[,BSFDataSet,ANY,ANY,ANY-method}
\title{Subset a BSFDataSet object}
\usage{
\S4method{[}{BSFDataSet,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \link{BSFDataSet} object.}

\item{i}{Position of the identifier or the name of the identifier itself.}

\item{j}{Not used.}

\item{...}{Additional arguments not used here.}

\item{drop}{if the signal not covered by the subsetted ranges should be
dropped or not}
}
\value{
A \link{BSFDataSet} object.
}
\description{
You can subset \link{BSFDataSet} by identifier or by position using the
\code{`[`} operator. Empty seqlevels are being droppend after the subset.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

bdsNew = bds[1:10]

}
