% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{pureClipGlobalFilter}
\alias{pureClipGlobalFilter}
\title{Filter PureCLIP sites by their score distribution}
\usage{
pureClipGlobalFilter(
  object,
  cutoff = 0.01,
  match.score = "score",
  quiet = FALSE
)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object with stored crosslink ranges
of width=1}

\item{cutoff}{numeric; defines the cutoff for which sites to keep, the
smallest step is 1\% (0.01)}

\item{match.score}{character; meta column name of the crosslink site
\code{\link{GenomicRanges}} object that holds the score which is used for
sub-setting}

\item{quiet}{logical; whether to print messages}
}
\value{
an object of class  \code{\link{BSFDataSet}} with its ranges filtered
by those that passed the threshold set with \code{cutoff}
}
\description{
Function that applies a filter on the global crosslink site score distribution.
The \code{\link{GenomicRanges}} contained in the \code{\link{BSFDataSet}} need to
have a meta-column that holds a numeric score value, which is used for filtering.
The name of the column can be set with \code{match.score}.
}
\details{
The function is part of the standard workflow performed by \code{\link{BSFind}}.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
# apply 5\% filter
pureClipGlobalFilter(object = bds, cutoff = 0.05)

}
\seealso{
\code{\link{BSFind}}, \code{\link{pureClipGlobalFilterPlot}}
}
