% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesKnockdown.r
\name{BayesKnockdown.diffExp}
\alias{BayesKnockdown.diffExp}
\title{Posterior Probabilities for 2-class Data}
\usage{
BayesKnockdown.diffExp(y1, y2, prior = 0.5, g = sqrt(ncol(y1) + ncol(y2)))
}
\arguments{
\item{y1}{Condition 1 outcome matrix: \code{p} (number of outcomes measured) by
\code{n1} (number of samples for condition 1).}

\item{y2}{Condition 2 outcome matrix: \code{p} (number of outcomes measured) by
\code{n2} (number of samples for condition 2).}

\item{prior}{Prior probabilities for the outcome variables. Defaults to 0.5
for all variables.}

\item{g}{The value to use for Zellner's \emph{g}-prior.
Defaults to the square root of the number of observations
(combined across both conditions).}
}
\value{
A vector of \code{p} posterior probabilities indicating
             the probability that each outcome variable is different
             between the two classes.
}
\description{
Calculates posterior probabilities for each gene in a set of experiments is
differentially expressed between two sets of experimental conditions. More
generally, it calculates posterior probabilities that each measured variable
is different between two classes, incorporating prior probabilities potentially
unique to each variable.
}
\examples{
n1 <- 15;
n2 <- 20;
p <- 10;
y1 <- matrix(nrow=p, data=rnorm(n1*p));
y2 <- matrix(nrow=p, data=rnorm(n2*p));
y2[3,] <- y2[3,] + 0.5;

BayesKnockdown.diffExp(y1, y2);
}

