% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{heatmap_plotter}
\alias{heatmap_plotter}
\title{Heatmap Plotter}
\usage{
heatmap_plotter(se, assay, nfeature, annotation_column, log_option)
}
\arguments{
\item{se}{SummarizedExperiment}

\item{assay}{normalized or corrected assay}

\item{nfeature}{number of features to display}

\item{annotation_column}{choose column}

\item{log_option}{TRUE if data should be logged before plotting (recommended
for sequencing counts), FALSE if data should not be logged (for instance,
data is already logged)}
}
\value{
heatmap plot
}
\description{
This function allows you to plot a heatmap
}
\examples{
library(scran)
se <- mockSCE()
heatmaps <- BatchQC::heatmap_plotter(se,
                                assay = "counts",
                                nfeature = 15,
                                annotation_column = c("Mutation_Status",
                                "Treatment"), log_option = FALSE)
correlation_heatmap <- heatmaps$correlation_heatmap
correlation_heatmap

heatmap <- heatmaps$topn_heatmap
heatmap

}
