% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{compareClusters}
\alias{compareClusters}
\title{Compare cluster outputs based on various clustering comparison measures.}
\usage{
compareClusters(
  se,
  func = c("ARI", "AMI", "MARI", "MARIraw", "RI", "NID", "NMI", "NVI"),
  digits = 3
)
}
\arguments{
\item{se}{A \code{SpatialExperiment},
\code{SingleCellExperiment} or \code{SummarizedExperiment}
  object with cluster labels in \code{colData(se)}.}

\item{func}{A string scalar specifying what clustering comparison measure to
compute. See \code{?aricode} for more information.}

\item{digits}{An integer scalar specifying the number of digits to round to.}
}
\value{
A matrix of cluster comparison measures.
}
\description{
Compare cluster outputs based on various clustering comparison measures.
}
\examples{
data(rings)
spe <- computeBanksy(rings, assay_name = "counts", M = 1, k_geom = c(15, 30))
spe <- runBanksyPCA(spe, M = 1, lambda = 0.2, npcs = 20)
spe <- clusterBanksy(spe, M = 1, lambda = 0.2, resolution = c(0.1, 1))
spe <- connectClusters(spe)
compareClusters(spe)

}
