% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaalChIP-generics.R, R/BaalChIP-methods.R
\name{summaryQC}
\alias{summaryQC}
\alias{summaryQC,BaalChIP-method}
\title{Method summaryQC}
\usage{
summaryQC(.Object)

\S4method{summaryQC}{BaalChIP}(.Object)
}
\arguments{
\item{.Object}{An object of the \code{\link{BaalChIP}} class.}
}
\value{
A list with two elements:
\itemize{
\item \code{filtering_stats} containing the number of variants that were filtered out in each filter category and the total number that 'pass' all filters.
\item \code{average_stats} containing the average number and average percentage of variants in each filter category, averaged across all analysed groups.
}
}
\description{
Generates summary of QC result.
}
\examples{
data('BaalObject')
summaryQC(BaalObject)
}
\seealso{
\code{\link{BaalChIP.run}}, \code{\link{plotQC}}
}
\author{
Ines de Santiago
}
