% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaalChIP-generics.R, R/BaalChIP-methods.R
\name{plotQC}
\alias{plotQC}
\alias{plotQC,BaalChIP-method}
\title{Method plotQC}
\usage{
plotQC(.Object, what = "barplot_per_group", addlegend = TRUE, plot = TRUE)

\S4method{plotQC}{BaalChIP}(.Object, what = "barplot_per_group", addlegend = TRUE, plot = TRUE)
}
\arguments{
\item{.Object}{An object of the \code{\link{BaalChIP}} class.}

\item{what}{A single character value indicating the type of plot. Options:
\itemize{
\item \code{overall_pie}: plots the average percentage of variants in each filter category (averaged across all groups analysed).
\item \code{boxplot_per_filter}: plots the number of variants that were filtered out per filter category.
\item \code{barplot_per_group}: plots the number of variants that were filtered out per group.
}}

\item{addlegend}{A logical value indicating if legend should be included in the plot (default TRUE).}

\item{plot}{a logical value to whether it should plot (TRUE) or not (FALSE). Default is TRUE.}
}
\value{
A plot
}
\description{
Produces different plots of QC results.
}
\examples{
data('BaalObject')
plotQC(BaalObject, what = 'overall_pie')
plotQC(BaalObject, what =  'boxplot_per_filter', addlegend=FALSE)
plotQC(BaalObject, what =  'barplot_per_group')
}
\seealso{
\code{\link{BaalChIP.run}}, \code{\link{summaryQC}}
}
\author{
Ines de Santiago
}
