% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr2g.R
\name{tr2g_EnsDb}
\alias{tr2g_EnsDb}
\title{Get transcript and gene info from EnsDb objects}
\usage{
tr2g_EnsDb(
  ensdb,
  Genome = NULL,
  get_transcriptome = TRUE,
  out_path = ".",
  write_tr2g = TRUE,
  other_attrs = NULL,
  use_gene_name = TRUE,
  use_transcript_version = TRUE,
  use_gene_version = TRUE,
  transcript_biotype_col = "TXBIOTYPE",
  gene_biotype_col = "GENEBIOTYPE",
  transcript_biotype_use = "all",
  gene_biotype_use = "all",
  chrs_only = TRUE,
  compress_fa = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{ensdb}{Ann \code{EnsDb} object, such as from \code{AnnotationHub} or
\code{EnsDb.Hsapiens.v86}.}

\item{Genome}{Either a \code{\link{BSgenome}} or a \code{\link{XStringSet}}
object of genomic sequences, where the intronic sequences will be extracted
from. Use \code{\link{genomeStyles}} to check which styles are supported for
your organism of interest; supported styles can be interconverted. If the
style in your genome or annotation is not supported, then the style of
chromosome names in the genome and annotation should be manually set to be
consistent.}

\item{get_transcriptome}{Logical, whether to extract transcriptome from
genome with the GTF file. If filtering biotypes or chromosomes, the filtered
\code{GRanges} will be used to extract transcriptome.}

\item{out_path}{Directory to save the outputs written to disk. If this
directory does not exist, then it will be created. Defaults to the current
working directory.}

\item{write_tr2g}{Logical, whether to write tr2g to disk. If \code{TRUE}, then
a file \code{tr2g.tsv} will be written into \code{out_path}.}

\item{other_attrs}{Character vector. Other attributes to get from the \code{EnsDb}
object, such as gene symbol and position on the genome.
Use \code{\link{columns}} to see which attributes are available.}

\item{use_gene_name}{Logical, whether to get gene names.}

\item{use_transcript_version}{Logical, whether to include version number in
the Ensembl transcript ID. To decide whether to
include transcript version number, check whether version numbers are included
in the \code{transcripts.txt} in the \code{kallisto} output directory. If that file
includes version numbers, then trannscript version numbers must be included
here as well. If that file does not include version numbers, then transcript
version numbers must not be included here.}

\item{use_gene_version}{Logical, whether to include version number in the
Ensembl gene ID. Unlike transcript
version number, it's up to you whether to include gene version number.}

\item{transcript_biotype_col}{Character vector of length 1. Tag in
\code{attribute} field corresponding to \emph{transcript} biotype.}

\item{gene_biotype_col}{Character vector of length 1. Tag in \code{attribute}
field corresponding to \emph{gene} biotype.}

\item{transcript_biotype_use}{Character, can be "all" or
a vector of \emph{transcript} biotypes to be used. Transcript biotypes aren't
entirely the same as gene biotypes. For instance, in Ensembl annotation,
\code{retained_intron} is a transcript biotype, but not a gene biotype. If
"cellranger", then a warning will be given. See \code{data("ensembl_tx_biotypes")}
for all available transcript biotypes from Ensembl.}

\item{gene_biotype_use}{Character, can be "all", "cellranger", or
a vector of \emph{gene} biotypes to be used. If "cellranger", then the biotypes
used by Cell Ranger's reference are used. See \code{data("cellranger_biotypes")}
for gene biotypes the Cell Ranger reference uses. See
\code{data("ensembl_gene_biotypes")} for all available gene biotypes from Ensembl.
Note that gene biotypes and transcript biotypes are not always the same.}

\item{chrs_only}{Logical, whether to include chromosomes only, for GTF and
GFF files can contain annotations for scaffolds, which are not incorporated
into chromosomes. This will also exclude haplotypes. Defaults to \code{TRUE}.
Only applicable to species found in \code{genomeStyles()}.}

\item{compress_fa}{Logical, whether to compress the output fasta file. If
\code{TRUE}, then the fasta file will be gzipped.}

\item{overwrite}{Logical, whether to overwrite if files with names of outputs
written to disk already exist.}
}
\value{
A data frame with at least 2 columns: \code{gene} for gene ID,
\code{transcript} for transcript ID, and optionally \code{gene_name}
for gene names. If \code{other_attrs} has been specified, then those will
also be columns in the data frame returned.
}
\description{
Bioconductor provides Ensembl genome annotation in \code{AnnotationHub}; older
versions of Ensembl annotation can be obtained from packages like
\code{EnsDb.Hsapiens.v86}. This is an alternative to querying Ensembl with
biomart; Ensembl's server seems to be less stable than that of Bioconductor.
However, more information and species are available on Ensembl biomart than
on \code{AnnotationHub}.
}
\examples{
library(EnsDb.Hsapiens.v86)
tr2g_EnsDb(EnsDb.Hsapiens.v86, get_transcriptome = FALSE, write_tr2g = FALSE,
 use_transcript_version = FALSE,
 use_gene_version = FALSE)
}
\seealso{
ensembl_gene_biotypes ensembl_tx_biotypes cellranger_biotypes

Other functions to retrieve transcript and gene info: 
\code{\link{sort_tr2g}()},
\code{\link{tr2g_TxDb}()},
\code{\link{tr2g_ensembl}()},
\code{\link{tr2g_fasta}()},
\code{\link{tr2g_gff3}()},
\code{\link{tr2g_gtf}()},
\code{\link{transcript2gene}()}
}
\concept{functions to retrieve transcript and gene info}
