% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCStan.R
\name{Stan2BASiCS}
\alias{Stan2BASiCS}
\title{Convert Stan fits to \code{\linkS4class{BASiCS_Chain}} objects.}
\usage{
Stan2BASiCS(
  x,
  gene_names = attr(x, "gene_names"),
  cell_names = attr(x, "cell_names"),
  size_factors = attr(x, "size_factors")
)
}
\arguments{
\item{x}{A stan object}

\item{gene_names, cell_names}{Gene and cell names. The reason this argument
exists is that by default, stan fit parameters are not named.
NOTE: this must be the same order as the
data supplied to \code{\link{BASiCStan}}.}

\item{size_factors}{Cell-specific scaling normalisation factors, to be
stored as part of the chain object when \code{WithSpikes=FALSE}.}
}
\value{
A \code{\linkS4class{BASiCS_Chain}} object.
}
\description{
Convert Stan fits to \code{\linkS4class{BASiCS_Chain}} objects.
}
\examples{
library("BASiCS")
sce <- BASiCS_MockSCE(NGenes = 10, NCells = 10)

fit_spikes <- BASiCStan(sce, ReturnBASiCS = FALSE, tol_rel_obj = 1)
summary(fit_spikes)
}
