% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_BANDITS_data.R
\docType{class}
\name{BANDITS_data-class}
\alias{BANDITS_data-class}
\alias{BANDITS_data}
\alias{show,BANDITS_data-method}
\title{BANDITS_data class}
\usage{
\S4method{show}{BANDITS_data}(object)
}
\arguments{
\item{object}{a 'BANDITS_data' object.}
}
\value{
\itemize{
\item \code{show(object)}: returns the number of genes and transcripts in the \code{BANDITS_data} object.
}
}
\description{
\code{BANDITS_data} contains all the information required to perform differential transcript usage (DTU).
\code{BANDITS_data} associates each gene (genes), to its transcript ids (transcripts),
effective transcript lengths (effLen), equivalence classes (classes) and respective counts (counts).
The same structure is also used for groups of genes with reads/fragments compatible with >1 gene (with uniqueId == FALSE); 
in this case the 'genes' field contains all the genes ids in the group.
Created via \code{\link{create_data}}.
}
\section{Slots}{

\describe{
\item{\code{genes}}{\code{list} of gene names: each element is a vector of 1 or 
more gene names indicating the genes to be analyzed together.}

\item{\code{transcripts}}{\code{list} of transcript names: each element is a vector of 1 or
more transcript names indicating the transcripts matching the gene names in the corresponding element of @genes object.}

\item{\code{effLen}}{\code{list} of transcript effective lengths: each element is a vector of 1 or
more numbers, indicating the effective length of the transcripts in the corresponding element of @transcripts object.}

\item{\code{classes}}{\code{list} of matrices: the (i,j) element of each matrix is 1 if the i-th transcript
is present in the j-th equivalence class, 0 otherwise.}

\item{\code{counts}}{\code{list} of matrices: the (i,j) element indicates the reads/fragments compatible with 
the i-th equivalence class in sample j.}

\item{\code{uniqueId}}{\code{logical}, it indicates if the element contains one gene to be analyzed alone (TRUE),
or more genes to be analyzed jointly (FALSE).}

\item{\code{all_genes}}{\code{vector}, it lists all the genes to be analyzed (with at least 2 transcripts).}
}}

\examples{
# load the pre-computed data:
data("input_data", package = "BANDITS")
show(input_data)

}
\seealso{
\code{\link{create_data}}, \code{\link{filter_transcripts}},  \code{\link{eff_len_compute}}
}
\author{
Simone Tiberi \email{simone.tiberi@uzh.ch}
}
