% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOutput.R
\name{getOutput}
\alias{getOutput}
\title{Download output files from Terra}
\usage{
getOutput(
  workspaceName,
  submissionId = NULL,
  keyword = NULL,
  dest_dir = ".",
  dry = TRUE
)
}
\arguments{
\item{workspaceName}{Name of the workspace}

\item{submissionId}{Submission Id. If it's not provided, the most recent
submission id with the 'succeeded' status will be used.}

\item{keyword}{A character string containing a regular expression to be
matched in the output file name. Under the default \code{NULL}, all the
outputs from the workflow, including log files, will be returned.}

\item{dest_dir}{Path to the directory where downloaded files are saved}

\item{dry}{To download the output data, set \code{dry = FALSE}.}
}
\value{
If \code{"dry=TRUE"}, this function will return a data frame with
two columns named 'filename' and 'name'.
\itemize{
\item \code{filename}: Name of the actual output files.
\item \code{name}: Name of the output defined in your workflow script.
This is how configuration refers the outputs.
}
}
\description{
Download output files from Terra
}
\examples{
library(AnVILBase)
if (has_avworkspace(strict = TRUE, platform = AnVILGCP::gcp())) {
getOutput(workspaceName = "Bioconductor-Workflow-DESeq2")
}

}
