% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_meta.R
\name{nmr_meta_export}
\alias{nmr_meta_export}
\title{Export Metadata to an Excel file}
\usage{
nmr_meta_export(
  nmr_dataset,
  xlsx_file,
  groups = c("info", "orig", "title", "external")
)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_family} object}

\item{xlsx_file}{"The .xlsx excel file"}

\item{groups}{A character vector. Use \code{"external"} for the external metadata or
the default for a more generic solution}
}
\value{
The Excel file name
}
\description{
Export Metadata to an Excel file
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
# nmr_meta_export(dataset, "metadata.xlsx")

}
\seealso{
Other metadata functions: 
\code{\link{Pipelines}},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_meta_groups}()}

Other nmr_dataset functions: 
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()}

Other nmr_dataset_1D functions: 
\code{\link{[.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{get_integration_with_metadata}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_ppm_resolution}()},
\code{\link{print.nmr_dataset_1D}()}

Other nmr_dataset_peak_table functions: 
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()}

Other import/export functions: 
\code{\link{Pipelines}},
\code{\link{files_to_rDolphin}()},
\code{\link{load_and_save_functions}},
\code{\link{nmr_data}()},
\code{\link{nmr_read_bruker_fid}()},
\code{\link{nmr_read_samples}()},
\code{\link{nmr_zip_bruker_samples}()},
\code{\link{save_files_to_rDolphin}()},
\code{\link{save_profiling_output}()},
\code{\link{to_ChemoSpec}()}
}
\concept{import/export functions}
\concept{metadata functions}
\concept{nmr_dataset functions}
\concept{nmr_dataset_1D functions}
\concept{nmr_dataset_peak_table functions}
