% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventsFilter.R
\name{eventsFilter}
\alias{eventsFilter}
\title{Filter the RangedSummarizedExperiment objects}
\usage{
eventsFilter(se, filter)
}
\arguments{
\item{se}{An \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment} object.
Outputs of \link{count5ends}.}

\item{filter}{An expression which, when evaluated in the context of
assays(se), is a logical vector indicating elements or rows to keep.
The expression results for each assay will be combined and use `or` operator
to filter the counts assays.}
}
\value{
A RangedSummarizedExperiment object with assays of
count matrix with bindingSites, proximalRegion and distalRegion as
column names and bindingSites GRanges object as rowRanges.
}
\description{
A helper function to subset the counts object outputed by
\link{count5ends}.
}
\examples{
bam <- system.file("extdata",
                   "KD.shift.rep1.bam",
                   package="ATACseqTFEA")
bsl <- system.file("extdata", "bindingSites.rds",
                   package="ATACseqTFEA")
bindingSites <- readRDS(bsl)
## get the count regions
bsEx <- expandBindingSites(bindingSites)
## count reads by 5'ends
res <- count5ends(bam, bindingSites=bindingSites,
                  bindingSitesWithGap=bsEx$bindingSitesWithGap,
                  bindingSitesWithProximal=bsEx$bindingSitesWithProximal,
                  bindingSitesWithProximalAndGap=
                      bsEx$bindingSitesWithProximalAndGap,
                  bindingSitesWithDistal=bsEx$bindingSitesWithDistal)
eventsFilter(res, proximalRegion>0)
eventsFilter(res, seqnames(res)=="chr1")
eventsFilter(res, sample(c(TRUE, FALSE), length(res), replace=TRUE))
eventsFilter(res, "proximalRegion>0")
filter <- "proximalRegion>0"
eventsFilter(res, filter)
filter <- sample(c(TRUE, FALSE), length(res), replace=TRUE)
eventsFilter(res, filter)
}
\author{
Jianhong Ou
}
