% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vPlot.R
\name{vPlot}
\alias{vPlot}
\title{V-plot}
\usage{
vPlot(
  bamfiles,
  index = bamfiles,
  pfm,
  genome,
  min.score = "95\%",
  bindingSites,
  seqlev = paste0("chr", c(1:22, "X", "Y")),
  upstream = 200,
  downstream = 200,
  maxSiteNum = 1e+06,
  draw = TRUE,
  ...
)
}
\arguments{
\item{bamfiles}{A vector of characters indicates the file names of bams.
All the bamfiles will be pulled together.}

\item{index}{The names of the index file of the 'BAM' file being processed;
This is given without the '.bai' extension.}

\item{pfm}{A Position frequency Matrix represented as a numeric matrix
with row names A, C, G and T.}

\item{genome}{An object of \link[BSgenome:BSgenome-class]{BSgenome}.}

\item{min.score}{The minimum score for counting a match.
Can be given as a character string containing a
percentage (e.g. "95%") of the highest possible
score or as a single number.
See \link[Biostrings]{matchPWM}.}

\item{bindingSites}{A object of \link[GenomicRanges:GRanges-class]{GRanges} indicates
candidate binding sites (eg. the output of fimo).}

\item{seqlev}{A vector of characters indicates the sequence levels.}

\item{upstream, downstream}{numeric(1) or integer(1).
Upstream and downstream of the binding region for
aggregate ATAC-seq footprint.}

\item{maxSiteNum}{numeric(1). Maximal number of predicted binding sites.
if predicted binding sites is more than this number, top maxSiteNum binding
sites will be used.}

\item{draw}{Plot or not. Default TRUE.}

\item{...}{parameters could be used by \link[graphics]{smoothScatter}}
}
\value{
an invisible data.frame for plot.
}
\description{
Aggregate ATAC-seq Fragment Midpoint vs. Length for a given motif generated
             over binding sites within the genome.
}
\examples{

bamfile <- system.file("extdata", "GL1.bam",
                       package="ATACseqQC")
library(MotifDb)
CTCF <- query(MotifDb, c("CTCF"))
CTCF <- as.list(CTCF)
library(BSgenome.Hsapiens.UCSC.hg19)
vPlot(bamfile, pfm=CTCF[[1]],
     genome=Hsapiens,
     min.score="95\%", seqlev="chr1",
     ylim=c(30, 250))

}
\references{
Jorja G. Henikoff, Jason A. Belsky, Kristina Krassovsky, 
David M. MacAlpine, and Steven Henikoff.
Epigenome characterization at single base-pair resolution.
PNAS 2011 108 (45) 18318-18323
}
\author{
Jianhong Ou
}
