% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PTscore.R
\name{PTscore}
\alias{PTscore}
\title{Promoter/Transcript body (PT) score}
\usage{
PTscore(
  obj,
  txs,
  seqlev = intersect(seqlevels(obj), seqlevels(txs)),
  upstream = 2000,
  downstream = 500
)
}
\arguments{
\item{obj}{an object of \link[GenomicAlignments:GAlignments-class]{GAlignments}}

\item{txs}{GRanges of transcripts}

\item{seqlev}{A vector of characters indicates the sequence levels.}

\item{upstream}{numeric(1) or integer(1). Start position of promoter. Default is 2000}

\item{downstream}{numeric(1) or integer(1). End position of promoter. Default is 500}
}
\value{
A object of \link[GenomicRanges:GRanges-class]{GRanges} with PT scores
}
\description{
PT score is calculated for coverage of promoter divided by the coverage of transcripts body.
PT score will show if the signal is enriched in promoters.
}
\examples{
 
library(GenomicRanges)
bamfile <- system.file("extdata", "GL1.bam", 
                       package="ATACseqQC", mustWork=TRUE)
gal1 <- readBamFile(bamFile=bamfile, tag=character(0), 
                    which=GRanges("chr1", IRanges(1, 1e6)), 
                    asMates=FALSE)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txs <- transcripts(TxDb.Hsapiens.UCSC.hg19.knownGene)
pt <- PTscore(gal1, txs)
}
\author{
Jianhong Ou
}
