% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_enrichment}
\alias{plot_enrichment}
\title{Generates plot for results from apl_topGO}
\usage{
plot_enrichment(genenr, ntop = 10)
}
\arguments{
\item{genenr}{data.frame. gene enrichment results table.}

\item{ntop}{numeric. Number of elements to plot.}
}
\value{
Returns a ggplot plot.
}
\description{
Plots the results from the data frame generated via apl_topGO.
}
\examples{
library(SeuratObject)
set.seed(1234)
cnts <- SeuratObject::LayerData(pbmc_small, assay = "RNA", layer = "counts")
cnts <- as.matrix(cnts)

# Run CA on example from Seurat

ca <- cacomp(pbmc_small,
             princ_coords = 3,
             return_input = FALSE,
             assay = "RNA",
             slot = "counts")

grp <- which(Idents(pbmc_small) == 2)
ca <- apl_coords(ca, group = grp)
ca <- apl_score(ca,
                mat = cnts)

enr <- apl_topGO(ca,
                 ontology = "BP",
                 organism = "hs")

plot_enrichment(enr)
}
