% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMOUNTAINC.R
\name{CGPFixSSTwolayer}
\alias{CGPFixSSTwolayer}
\title{Module Identification for two-layer network}
\usage{
CGPFixSSTwolayer(W1, z1, x0, W2, z2, y0, interlayerA, lambda1 = 1,
  lambda2 = 1, lambda3 = 1, maxiter = 100, a1 = 0.5, a2 = 0.5)
}
\arguments{
\item{W1}{edge score matrix of the network 1, n_1 x n_1 matrix}

\item{z1}{node score vector of the network 1, n_1-length vector}

\item{x0}{initial solution of network 1, n_1-length vector}

\item{W2}{edge score matrix of the network 2, n_2 x n_2 matrix}

\item{z2}{node score vector of the network 2, n_2-length vector}

\item{y0}{initial solution of network 2, n_2-length vector}

\item{interlayerA}{inter-layer links weight, n_1 x n_2 matrix}

\item{lambda1}{parameter in objective, coefficient of node score of network 1}

\item{lambda2}{parameter in objective, coefficient of node score of network 2}

\item{lambda3}{parameter in objective, coefficient of inter-layer links part}

\item{maxiter}{maximal interation of whole procedure}

\item{a1}{parameter in elastic net the same as in \code{\link{EuclideanProjectionENNORM}}}

\item{a2}{parameter in elastic net the same as in \code{\link{EuclideanProjectionENNORM}}}
}
\value{
a list containing solution for network 1 and network 2 and objective
}
\description{
Call C version of moduleIdentificationGPFixSSTwolayer
}
\examples{
n1=100
k1=20
theta1 = 0.5
n2=80
k2=10
theta2 = 0.5
ppresult <- twolayernetworkSimulation(n1,k1,theta1,n2,k2,theta2)
A <- ppresult[[3]]
pp <- ppresult[[1]]
moduleid <- pp[[3]]
netid <- 1:n1
restp<- netid[-moduleid]
pp2 <- ppresult[[2]]
moduleid2 <- pp2[[3]]
## use default parameters here
modres=CGPFixSSTwolayer(pp[[1]],pp[[2]],rep(1/n1,n1),
pp2[[1]],pp2[[2]],rep(1/n2,n2),A)
predictedid<-which(modres[[1]]!=0)
recall = length(intersect(predictedid,moduleid))/length(moduleid)
precise = length(intersect(predictedid,moduleid))/length(predictedid)
F1 = 2*precise*recall/(precise+recall)
predictedid2<-which(modres[[2]]!=0)
recall2 = length(intersect(predictedid2,moduleid2))/length(moduleid2)
precise2 = length(intersect(predictedid2,moduleid2))/length(predictedid2)
F2 = 2*precise2*recall2/(precise2+recall2)
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
AMOUNTAIN
}
\seealso{
\code{\link{moduleIdentificationGPFixSSTwolayer}}
}
\keyword{identification,}
\keyword{module}
\keyword{two-layer}

