% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMOUNTAINC.R
\name{CGPFixSSMultiLayer}
\alias{CGPFixSSMultiLayer}
\title{Module Identification for multi-layer network}
\usage{
CGPFixSSMultiLayer(W, listzs, x0, a = 0.5, lambda = 1, maxiter = 50)
}
\arguments{
\item{W}{edge score matrix of the network, n x n matrix}

\item{listzs}{a list of node score vectors, each layer has a n-length vector}

\item{x0}{initial solution, n-length vector}

\item{a}{parameter in elastic net the same as in \code{\link{EuclideanProjectionENNORM}}}

\item{lambda}{parameter in objective, coefficient of node score of other layers}

\item{maxiter}{maximal interation of whole procedure}
}
\value{
a list containing solution for network 1 and network 2
}
\description{
Call C version of moduleIdentificationGPFixSSMultilayer
}
\examples{
n = 100
k = 20
L = 5
theta = 0.5
cpl <- multilayernetworkSimulation(n,k,theta,L)
listz <- list()
for (i in 1:L){
listz[[i]] <- cpl[[i+2]]
}
moduleid <- cpl[[2]]
## use default parameters here
x <- CGPFixSSMultiLayer(cpl[[1]],listz,rep(1/n,n))
predictedid <- which(x[[2]]!=0)
recall <- length(intersect(predictedid,moduleid))/length(moduleid)
precise <- length(intersect(predictedid,moduleid))/length(predictedid)
Fscore <- (2*precise*recall/(precise+recall))
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
AMOUNTAIN
}
\seealso{
\code{\link{moduleIdentificationGPFixSSMultilayer}}
}
\keyword{identification,}
\keyword{module}
\keyword{multi-layer}

