% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMOUNTAINC.R
\name{CGPFixSS}
\alias{CGPFixSS}
\title{Module Identification}
\usage{
CGPFixSS(W, z, x0, a = 0.5, lambda = 1, maxiter = 50)
}
\arguments{
\item{W}{edge score matrix of the network, n x n matrix}

\item{z}{node score vector of the network, n-length vector}

\item{x0}{initial solution, n-length vector}

\item{a}{parameter in elastic net the same as in \code{\link{EuclideanProjectionENNORM}}}

\item{lambda}{parameter in objective, coefficient of node score part}

\item{maxiter}{maximal interation of whole procedure}
}
\value{
a list containing function objective vector and the solution
}
\description{
Call C version of moduleIdentificationGPFixSS
}
\examples{
n = 100
k = 20
theta = 0.5
pp <- networkSimulation(n,k,theta)
moduleid <- pp[[3]]
## use default parameters here
x <- CGPFixSS(pp[[1]],pp[[2]],rep(1/n,n))
predictedid<-which(x[[2]]!=0)
recall <- length(intersect(predictedid,moduleid))/length(moduleid)
precise <- length(intersect(predictedid,moduleid))/length(predictedid)
Fscore <- (2*precise*recall/(precise+recall))
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
AMOUNTAIN
}
\seealso{
\code{\link{moduleIdentificationGPFixSS}}
}
\keyword{identification}
\keyword{module}

