% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clr_corr.R
\name{aldex.corr}
\alias{aldex.corr}
\title{Calculate correlation with a continuous variable}
\usage{
aldex.corr(clr, cont.var)
}
\arguments{
\item{clr}{An \code{ALDEx2} object. The output of \code{aldex.clr}.}

\item{cont.var}{A continuous numeric vector}
}
\value{
Returns a data.frame of the average
 Pearson, Spearman and Kendall
 coefficients and their p-values for each feature,
 with FDR appended as a \code{BH} column.
}
\description{
\code{aldex.corr} calculates the expected values for the correlation
 between each feature and a continuous variable, using data returned
 returned by \code{aldex.clr} and a vector of the continuous variable.
 Returns results of Pearson, Spearman and Kendall tests.
}
\examples{
data(selex)
#subset for efficiency
selex <- selex[1:50,]
conds <- c(rep("N", 7), rep("S",7))
cont.var <-  c(rep(1,7), rep(2,7))
x <- aldex.clr(selex, conds, mc.samples=16)
corr.test <- aldex.corr(x, cont.var)
}
\references{
Please use the citation given by
 \code{citation(package="ALDEx2")}.
}
\seealso{
\code{\link{aldex}},
 \code{\link{aldex.clr}},
 \code{\link{aldex.ttest}},
 \code{\link{aldex.kw}},
 \code{\link{aldex.glm}},
 \code{\link{aldex.effect}},
 \code{\link{aldex.corr}},
 \code{\link{selex}}
}
\author{
Arianne Albert, Greg Gloor, Thom Quinn
}
