% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper.R
\name{CheckArguments_Impute}
\alias{CheckArguments_Impute}
\title{Argument check to Impute()}
\usage{
CheckArguments_Impute(data, method.choice, do, tr.length, labels,
cell.clusters, true.zero.thr, drop_thre)
}
\arguments{
\item{data}{matrix; raw counts (genes as rows and samples as columns)}

\item{method.choice}{character; best performing method in training data for
each gene}

\item{do}{character; choice of methods to be used for imputation. Currently
supported methods are \code{'Baseline'}, \code{'DrImpute'},
\code{'Network'}, and \code{'Ensemble'}. Defaults to \code{'Ensemble'}.
Not case-sensitive. Can include one or more methods. Non-supported methods
will be ignored.}

\item{tr.length}{matrix with at least 2 columns: 'hgnc_symbol' and
'transcript_length'}

\item{labels}{character; vector specifying the cell type of each column of
\code{data}}

\item{cell.clusters}{integer; number of cell subpopulations}

\item{true.zero.thr}{if set to NULL (default), no true zero estimation is
performed. Set to numeric value between 0 and 1 for estimation. Value
corresponds to the threshold used to determine true zeros: if the probability
of dropout is lower than \code{true.zero.thr}, the imputed entries are set
to zero.}

\item{drop_thre}{numeric; between 0 and 1 specifying the threshold to
determine dropout values}
}
\value{
NULL object
}
\description{
\code{CheckArguments_Impute} checks whether the arguments passed
to \code{Impute} are correct.
}
