#' @title Aedes aegypti RNA-seq data expression
#' @description A sample fragment of gene expression from an RNA-seq 
#' experiment of Aedes aegypti mosquito.
#' @format A data frame with 34 rows and 5 variables
#' @name ExpressionAedes
#' @references AKBARI, O. S. et al. The developmental transcriptome of the 
#' mosquito aedes aegypti, an invasive species and major arbovirus vector. G3:
#' Genes— Genomes— Genetics, Genetics Society of America, v. 3, n. 9, 
#' p. 1493–1509, 2013.
#' @examples 
#' data(ExpressionAedes)
NULL

#' @title Relation between Aedes aegypti genes and KEGG pathways as 
#' ADAM input
#' @description A relation between the genes in the ExpressionAedes data and
#' their respective KEGG pathways (GFAGs).
#' @format A data frame with 200 rows and 2 variables
#' @name KeggPathwaysAedes
#' @references Molan, A. L. 2018. “Construction of a Tool for Multispecies
#' Genic Functional Enrichment Analysis Among Comparative Samples.”
#' Master’s thesis Institute of Biosciences of Botucatu – Univ. Estadual
#' Paulista. http://hdl.handle.net/11449/157105.
#' @examples
#' data(KeggPathwaysAedes)
NULL