% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexmodel.R
\name{ABSSeqlm}
\alias{ABSSeqlm}
\title{Differential expression analysis for complex desgin.}
\usage{
ABSSeqlm(object, design, condA, condB = NULL, lmodel = TRUE,
  preval = 0.05, qforkappa = 0, adjmethod = "BH", scale = FALSE,
  quiet = FALSE, ...)
}
\arguments{
\item{object}{a \code{\link{ABSDataSet}} object (not need 'groups' information).}

\item{design}{a numeric matrix for expriment, with samples and factors in rows and colnums, respectively. Design respresents the satuarated model.}

\item{condA}{a vector of factors for DE analysis, which could be redundant, see \code{\link{aFoldcomplexDesign}}.}

\item{condB}{a vector of factors for DE analysis, which could be redundant, default is null, if not provide, the DE analysis will switch to 
assess difference across factors in condA (analysis of variance). If provide, DE analysis will focus on contrast between condB and condA (condB-condA).
See \code{\link{aFoldcomplexDesign}}. The unique factors in condA+condB represents the reduced model.}

\item{lmodel}{switch of fit linear model from limma-lmFit under design, default is TRUE. If TRUE, a gene-specific residual varaince will
be estimated from (satuarated model - reduced model). Satuarated model includes all factors in design matrix and reduced model includes factors in condA+condB.
if satuarated model == reduced model, the DE analysis performs pairwise comparison or one-way analysis of variance. See \code{\link{aFoldcomplexDesign}}.}

\item{preval}{parameter for \code{\link{aFoldcomplexDesign}}, prior value for controlling of variance scale in case over-scaled, default is 0.05,}

\item{qforkappa}{parameter for \code{\link{aFoldcomplexDesign}}, quantile for estimating kappa(>=qforkappa), default is 0 (no trimming of data).}

\item{adjmethod}{defualt is 'BH', method for p-value adjusted, see \code{\link{p.adjust.methods}} for details}

\item{scale}{switch for scaling fold change according to common SD under log2 transformation, default is FALSE.}

\item{quiet}{default is FALSE, whether to print messages at each step}

\item{...}{parameters passed to lmFit in limma}
}
\value{
a result table with additional elements, including:
basemean, log of basemean, 
foldChange, shrinked (expression level and gene-specific) log2 of fold-change, B - A, or (SDs under log2 for analysis of variance)
pvalue, pvalue from NB distribution model, 
p.adj, adjuested p-value used p.adjust method.
scaledlogFC, scaled logFC if scale=TRUE.
}
\description{
This function performs a default analysis by calling, in order, the functions:
\code{\link{normalFactors}},
\code{\link{aFoldcomplexDesign}},
}
\details{
This function uses a linear model (limma-lmFit) to infer DE under complex design.
}
\examples{

data(simuN5)
groups=factor(simuN5$groups)
obj <- ABSDataSet(counts=simuN5$counts)
design <- model.matrix(~0+groups)
res <- ABSSeqlm(obj,design,condA=c("groups0"),condB=c("groups1"))
head(res)
}
\references{
Wentao Yang, Philip Rosenstiel & Hinrich Schulenburg: ABSSeq: a new RNA-Seq analysis method based on modelling absolute expression differences
}
\author{
Wentao Yang
}
