/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq;

import edu.msu.cme.rdp.readseq.ToFasta;
import edu.msu.cme.rdp.readseq.ToFastq;
import edu.msu.cme.rdp.readseq.utils.ResampleSeqFile;
import edu.msu.cme.rdp.readseq.utils.RevComplement;
import edu.msu.cme.rdp.readseq.utils.RmDupSeqs;
import edu.msu.cme.rdp.readseq.utils.SeqFileSplitter;
import edu.msu.cme.rdp.readseq.utils.SequenceSelector;
import edu.msu.cme.rdp.readseq.writers.StkWriter;
import java.util.Arrays;

public class ReadSeqMain {
    public static void main(String[] args) throws Exception {
        String usage = "USAGE: ReadSeqMain <subcommand> <subcommand args ...>\n\trandom-sample  - random select a subset or subregion of sequences\n\treverse-comp   - reverse complement sequences\n\trm-dupseq      - remove identical or substring of sequences\n\tselect-seqs    - select or deselect sequences from a file\n\tsplit          - split sequences\n\tto-fasta       - convert to fasta format\n\tto-fastq       - convert to fastq format\n\tto-stk         - convert to stk format";
        if (args.length == 0) {
            System.err.println(usage);
            return;
        }
        String cmd = args[0];
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        if (cmd.equals("select-seqs")) {
            SequenceSelector.main(newArgs);
        } else if (cmd.equals("random-sample")) {
            ResampleSeqFile.main(newArgs);
        } else if (cmd.equals("reverse-comp")) {
            RevComplement.main(newArgs);
        } else if (cmd.equals("rm-dupseq")) {
            RmDupSeqs.main(newArgs);
        } else if (cmd.equals("to-fasta")) {
            ToFasta.main(newArgs);
        } else if (cmd.equals("to-fastq")) {
            ToFastq.main(newArgs);
        } else if (cmd.equals("to-stk")) {
            StkWriter.main(newArgs);
        } else if (cmd.equals("split")) {
            SeqFileSplitter.main(newArgs);
        } else {
            System.err.println("ERROR: wrong subcommand");
            System.err.println(usage);
            return;
        }
    }
}

