/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojava.bio.program.search.SearchBuilder;
import org.biojava.bio.program.search.SearchParser;
import org.biojava.utils.ParserException;

public class SearchReader
implements Iterator {
    private BufferedReader reader;
    private SearchBuilder handler;
    private SearchParser parser;
    private boolean moreSearchesAvailable = true;

    public SearchReader(BufferedReader bufferedReader, SearchBuilder searchBuilder, SearchParser searchParser) {
        this.reader = bufferedReader;
        this.handler = searchBuilder;
        this.parser = searchParser;
    }

    public boolean hasNext() {
        block2: {
            if (this.moreSearchesAvailable) break block2;
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.moreSearchesAvailable;
    }

    public Object next() throws NoSuchElementException {
        if (!this.moreSearchesAvailable) {
            throw new NoSuchElementException("Attempt to read search result from empty stream");
        }
        try {
            this.moreSearchesAvailable = this.parser.parseSearch(this.reader, this.handler);
            return this.handler.makeSearchResult();
        }
        catch (ParserException parserException) {
            throw new NoSuchElementException("No valid search result could be parsed from this stream: parse failed at line " + parserException.getLineNumber() + " of input");
        }
        catch (IOException iOException) {
            throw new NoSuchElementException("No valid search result could be parsed from this stream");
        }
        catch (BioException bioException) {
            throw new NoSuchElementException("No valid search result could be parsed from this stream: " + bioException.getMessage());
        }
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

