/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASCapabilities;
import org.biojava.bio.program.das.DASGFFParser;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.DASXFFParser;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class FeatureRequestManager {
    private static Map requestManagers = new HashMap();
    private Set openTickets = new HashSet();
    private URL dataSourceURL;

    public FeatureRequestManager(URL uRL) {
        this.dataSourceURL = uRL;
    }

    private boolean fetchAll(Ticket ticket) throws ParseException, BioException {
        try {
            Object object;
            boolean bl = DASCapabilities.checkCapable(new URL(this.dataSourceURL, ".."), "dasExtendedRequest", "features");
            if (!bl) {
                return false;
            }
            if (this.openTickets.size() <= 1) {
                return false;
            }
            HashSet<Ticket> hashSet = new HashSet<Ticket>();
            String string = ticket.getType();
            String string2 = ticket.getCategory();
            Iterator iterator = this.openTickets.iterator();
            while (iterator.hasNext()) {
                object = (Ticket)iterator.next();
                if (!FeatureRequestManager.stringCompare(string, ((Ticket)object).getType()) || !FeatureRequestManager.stringCompare(string2, ((Ticket)object).getCategory())) continue;
                hashSet.add((Ticket)object);
            }
            if (hashSet.size() <= 1) {
                return false;
            }
            System.err.println("Wheee, extended fetch of " + hashSet.size() + " requests (" + string + "," + string2 + ")");
            object = new URL(this.dataSourceURL, "features");
            HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "text/xml");
            httpURLConnection.setDoOutput(true);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            PrintStream printStream = new PrintStream(outputStream);
            HashMap<String, Ticket> hashMap = new HashMap<String, Ticket>();
            printStream.print("<featureRequest encoding=\"xff\"");
            if (string != null) {
                printStream.print(" type=\"" + string + "\"");
            }
            if (string2 != null) {
                printStream.print(" category=\"" + string2 + "\"");
            }
            printStream.println(">");
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                Ticket ticket2 = (Ticket)iterator2.next();
                printStream.println("  <segment id=\"" + ticket2.getID() + "\" />");
                hashMap.put(ticket2.getID(), ticket2);
            }
            printStream.println("</featureRequest>");
            httpURLConnection.connect();
            int n = httpURLConnection.getHeaderFieldInt("X-DAS-Status", 0);
            if (n == 0) {
                throw new BioError("Not a DAS server: " + ((URL)object).toString());
            }
            if (n != 200) {
                throw new BioError("DAS error (status code = " + n + ")");
            }
            InputSource inputSource = new InputSource(httpURLConnection.getInputStream());
            DOMParser dOMParser = DASSequence.nonvalidatingParser();
            dOMParser.parse(inputSource);
            Element element = dOMParser.getDocument().getDocumentElement();
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Object object2;
                    String string3;
                    Element element2 = (Element)node;
                    String string4 = element2.getTagName();
                    if ("SEGMENT".equals(string4)) {
                        string3 = element2.getAttribute("id");
                        object2 = (Ticket)hashMap.get(string3);
                        if (object2 == null) {
                            throw new ParseException("Response segment " + string3 + " wasn't requested");
                        }
                        DASXFFParser.INSTANCE.parseSegment(element2, ((Ticket)object2).getOutputListener());
                        ((Ticket)object2).setAsFetched();
                        this.openTickets.remove(object2);
                    } else if ("segmentNotAnnotated".equals(string4)) {
                        string3 = element2.getAttribute("id");
                        object2 = (Ticket)hashMap.get(string3);
                        if (object2 == null) {
                            throw new ParseException("Response segment " + string3 + " wasn't requested");
                        }
                        SeqIOListener seqIOListener = ((Ticket)object2).getOutputListener();
                        seqIOListener.startSequence();
                        seqIOListener.endSequence();
                        ((Ticket)object2).setAsFetched();
                        this.openTickets.remove(object2);
                    } else if ("segmentError".equals(string4)) {
                        string3 = element2.getAttribute("id");
                        object2 = element2.getAttribute("error");
                        throw new ParseException("Error " + (String)object2 + " fetching " + string3);
                    }
                }
                node = node.getNextSibling();
            }
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException);
        }
        return true;
    }

    private void fetchTicket(Ticket ticket) throws ParseException, BioException {
        System.err.println("Sigh, just fetching one featureSet (" + ticket.getType() + "," + ticket.getCategory() + ")");
        try {
            boolean bl = DASCapabilities.checkCapable(new URL(this.dataSourceURL, ".."), "featureTable", "xff");
            String string = "";
            if (ticket.getType() != null) {
                string = String.valueOf(string) + ";type=" + ticket.getType();
            }
            if (ticket.getCategory() != null) {
                string = String.valueOf(string) + ";category=" + ticket.getCategory();
            }
            if (bl) {
                URL uRL = new URL(this.dataSourceURL, "features?encoding=xff;ref=" + ticket.getID() + string);
                DASXFFParser.INSTANCE.parseURL(uRL, ticket.getOutputListener());
            } else {
                URL uRL = new URL(this.dataSourceURL, "features?ref=" + ticket.getID() + string);
                DASGFFParser.INSTANCE.parseURL(uRL, ticket.getOutputListener());
            }
            this.openTickets.remove(ticket);
            ticket.setAsFetched();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public static FeatureRequestManager getManager(URL uRL) {
        FeatureRequestManager featureRequestManager = (FeatureRequestManager)requestManagers.get(uRL);
        if (featureRequestManager == null) {
            featureRequestManager = new FeatureRequestManager(uRL);
            requestManagers.put(uRL, featureRequestManager);
        }
        return featureRequestManager;
    }

    public Ticket requestFeatures(String string, SeqIOListener seqIOListener) {
        return this.requestFeatures(string, seqIOListener, null, null);
    }

    public Ticket requestFeatures(String string, SeqIOListener seqIOListener, String string2, String string3) {
        Ticket ticket = new Ticket(string, seqIOListener, string2, string3);
        this.openTickets.add(ticket);
        return ticket;
    }

    private static boolean stringCompare(String string, String string2) {
        if (string == null || string2 == null) {
            return string == string2;
        }
        return string.equals(string2);
    }

    public class Ticket {
        private boolean _isFired = false;
        private String id;
        private String type;
        private String category;
        private SeqIOListener outputListener;

        public Ticket(String string, SeqIOListener seqIOListener, String string2, String string3) {
            this.id = string;
            this.outputListener = seqIOListener;
            this.type = string2;
            this.category = string3;
        }

        public void doFetch() throws ParseException, BioException {
            if (!this._isFired && !FeatureRequestManager.this.fetchAll(this)) {
                FeatureRequestManager.this.fetchTicket(this);
            }
        }

        private String getCategory() {
            return this.category;
        }

        private String getID() {
            return this.id;
        }

        private SeqIOListener getOutputListener() {
            return this.outputListener;
        }

        private String getType() {
            return this.type;
        }

        public boolean isFetched() {
            return this._isFired;
        }

        private void setAsFetched() {
            this._isFired = true;
            this.id = null;
            this.outputListener = null;
        }
    }
}

