/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.dist.AbstractDistribution;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IgnoreCountsTrainer;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ListWrapper;

public class PairDistribution
extends AbstractDistribution
implements Serializable {
    private static Map cache = new HashMap();
    private static ListWrapper gopher = new ListWrapper();
    private Distribution first;
    private Distribution second;
    private Alphabet alphabet;
    private Distribution nullModel;

    public PairDistribution(Distribution distribution, Distribution distribution2) {
        this.first = distribution;
        this.second = distribution2;
        this.alphabet = AlphabetManager.getCrossProductAlphabet(Arrays.asList(distribution.getAlphabet(), distribution2.getAlphabet()));
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public Distribution getNullModel() {
        return PairDistribution.getNullModel(this.first, this.second);
    }

    protected static Distribution getNullModel(Distribution distribution, Distribution distribution2) {
        Map map = cache;
        synchronized (map) {
            Distribution distribution3;
            distribution = distribution.getNullModel();
            distribution2 = distribution2.getNullModel();
            List<Object> list = Arrays.asList(distribution, distribution2);
            gopher.setList(list);
            SoftReference softReference = (SoftReference)cache.get(gopher);
            if (softReference == null) {
                distribution3 = new PairDistribution(distribution, distribution2);
                cache.put(new ListWrapper(list), new SoftReference<Distribution>(distribution3));
            } else {
                distribution3 = (Distribution)softReference.get();
                if (distribution3 == null) {
                    distribution3 = new PairDistribution(distribution, distribution2);
                    cache.put(new ListWrapper(list), new SoftReference<Distribution>(distribution3));
                }
            }
            Distribution distribution4 = distribution3;
            Object var4_7 = null;
            return distribution4;
        }
    }

    public double getWeightImpl(AtomicSymbol atomicSymbol) throws IllegalSymbolException {
        List list = atomicSymbol.getSymbols();
        Symbol symbol = (Symbol)list.get(0);
        Symbol symbol2 = (Symbol)list.get(1);
        return this.first.getWeight(symbol) * this.second.getWeight(symbol2);
    }

    public void registerWithTrainer(ModelTrainer modelTrainer) {
        modelTrainer.registerDistribution(this.first);
        modelTrainer.registerDistribution(this.second);
        modelTrainer.registerTrainer(this, new PairTrainer());
    }

    protected void setNullModelImpl(Distribution distribution) throws IllegalAlphabetException, ChangeVetoException {
        throw new ChangeVetoException("PairDistribution objects can't have their null models changed.");
    }

    public void setWeightImpl(AtomicSymbol atomicSymbol, double d) throws ChangeVetoException {
        throw new ChangeVetoException("Can't set the weight directly in a PairDistribution. You must set the weights in the underlying distributions.");
    }

    private class PairTrainer
    extends IgnoreCountsTrainer
    implements Serializable {
        PairTrainer() {
        }

        public void addCount(DistributionTrainerContext distributionTrainerContext, Symbol symbol, double d) throws IllegalSymbolException {
            PairDistribution.this.getAlphabet().validate(symbol);
            if (!(symbol instanceof AtomicSymbol)) {
                throw new IllegalSymbolException("Can't add counts for ambiguity symbols. Got: " + symbol.getName());
            }
            List list = ((BasisSymbol)symbol).getSymbols();
            Symbol symbol2 = (Symbol)list.get(0);
            Symbol symbol3 = (Symbol)list.get(1);
            distributionTrainerContext.addCount(PairDistribution.this.first, symbol2, d);
            distributionTrainerContext.addCount(PairDistribution.this.second, symbol3, d);
        }
    }
}

