/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.javautils;

import com.gkano.bioinfo.tree.HierarchicalCluster;
import com.gkano.bioinfo.var.Logger;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;

public class JRITools_JavaUtils {
    private static JRITools_JavaUtils instance = null;
    private static Rengine re = null;

    private JRITools_JavaUtils() {
    }

    public static JRITools_JavaUtils getInstance(String[] args) {
        if (instance == null) {
            instance = new JRITools_JavaUtils(args);
        }
        return instance;
    }

    public JRITools_JavaUtils(String[] args) {
        try {
            if (args == null) {
                args = new String[]{"--quiet", "--vanilla"};
            }
            if (!Rengine.versionCheck()) {
                System.err.println("** Version mismatch - Java files don't match library version.");
                System.exit(1);
            }
            System.err.println("Creating Rengine (with arguments ) = " + Arrays.toString(args));
            re = new Rengine(args, false, (RMainLoopCallbacks)new TextConsole());
            System.err.println("Rengine created, waiting for R");
            if (!re.waitForR()) {
                System.err.println("Cannot load R");
            }
        }
        catch (Exception e) {
            Logger.error(this.getClass(), e.getMessage());
        }
    }

    public void shutdown() {
        try {
            re.end();
        }
        catch (Exception e) {
            Logger.error(this, e.getMessage());
        }
    }

    public TreeMap<Integer, TreeSet<String>> dynamicTreeCut(String treeString, double[][] distances, String[] labels, Integer minClusterSize, Double cutHeight, boolean extra) {
        try {
            re.eval("library(\"dynamicTreeCut\")");
            re.eval("library(\"ape\")");
            re.assign("treeString", treeString);
            this.assignAsRMatrix(re, distances, "distancesMatrix");
            re.assign("rawLabels", labels);
            re.assign("colLabels", labels);
            re.eval("rownames(distancesMatrix) <- rawLabels");
            re.eval("colnames(distancesMatrix) <- colLabels");
            re.eval("tree <- read.tree(text=treeString);");
            System.err.println("\nIs ultrametric=" + re.eval("is.ultrametric(tree);").asBool().toString());
            re.eval("tree_hclust <- as.hclust(tree);");
            if (minClusterSize == null) {
                minClusterSize = 1;
            }
            String command = extra ? "treecut_hybrid <- cutreeDynamic(dendro = tree_hclust, cutHeight = " + (Serializable)(cutHeight == null ? "NULL" : Double.valueOf(2.0 * cutHeight)) + ", minClusterSize = " + minClusterSize + ", method = \"hybrid\", distM = distancesMatrix, deepSplit = 1, maxCoreScatter = NULL, minGap = NULL, maxAbsCoreScatter = NULL, minAbsGap = NULL, minSplitHeight = NULL, minAbsSplitHeight = NULL, verbose = 2, indent = 0);" : "treecut_hybrid <- cutreeDynamic(dendro = tree_hclust, cutHeight = " + (Serializable)(cutHeight == null ? "NULL" : Double.valueOf(2.0 * cutHeight)) + ", minClusterSize = " + minClusterSize + ", method = \"hybrid\", distM = distancesMatrix, deepSplit = 1, maxCoreScatter = NULL, minGap = NULL, maxAbsCoreScatter = NULL, minAbsGap = NULL, minSplitHeight = NULL, minAbsSplitHeight = " + (Serializable)(cutHeight == null ? "NULL" : Double.valueOf(2.0 * cutHeight)) + ", verbose = 2, indent = 0);";
            re.eval(command);
            System.err.println("\ntreecut_hybrid");
            REXP x = re.eval("treecut_hybrid");
            System.err.println(x);
            System.err.println("minClusterSize=" + minClusterSize);
            System.err.println("cutHeight=" + cutHeight);
            double[] result = x.asDoubleArray();
            HierarchicalCluster hc = new HierarchicalCluster(true);
            TreeMap<Integer, TreeSet<String>> clusters = hc.findClusters(result, labels);
            return clusters;
        }
        catch (Exception e) {
            Logger.error(this, e.getMessage());
            return null;
        }
    }

    private REXP assignAsRMatrix(Rengine rEngine, double[][] sourceArray, String nameToAssignOn) {
        if (sourceArray.length == 0) {
            return null;
        }
        double[] temp1Darray = new double[sourceArray.length * sourceArray[0].length];
        for (int i = 0; i < sourceArray.length; ++i) {
            System.arraycopy(sourceArray[i], 0, temp1Darray, i, sourceArray[i].length);
        }
        rEngine.assign("temp", temp1Darray);
        REXP resultMatrix = rEngine.eval(nameToAssignOn + " <- matrix(temp, " + sourceArray.length + ", " + sourceArray[0].length + ", byrow = T) ");
        return resultMatrix;
    }

    private class TextConsole
    implements RMainLoopCallbacks {
        private TextConsole() {
        }

        public void rWriteConsole(Rengine re, String text, int oType) {
            System.out.print(text);
        }

        public void rBusy(Rengine re, int which) {
            System.out.println("rBusy(" + which + ")");
        }

        public String rReadConsole(Rengine re, String prompt, int addToHistory) {
            System.out.print(prompt);
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String s = br.readLine();
                return s == null || s.length() == 0 ? s : s + "\n";
            }
            catch (IOException e) {
                System.out.println("jriReadConsole exception: " + e.getMessage());
                return null;
            }
        }

        public void rShowMessage(Rengine re, String message) {
            System.out.println("rShowMessage \"" + message + "\"");
        }

        public String rChooseFile(Rengine re, int newFile) {
            FileDialog fd = new FileDialog(new Frame(), newFile == 0 ? "Select a file" : "Select a new file", newFile == 0 ? 0 : 1);
            fd.show();
            String res = null;
            if (fd.getDirectory() != null) {
                res = fd.getDirectory();
            }
            if (fd.getFile() != null) {
                res = res == null ? fd.getFile() : res + fd.getFile();
            }
            return res;
        }

        public void rFlushConsole(Rengine re) {
        }

        public void rLoadHistory(Rengine re, String filename) {
        }

        public void rSaveHistory(Rengine re, String filename) {
        }
    }
}

