/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.DomainException;

public class LinearSolve {
    private int N;
    private double[][] LU;
    private int[] p;
    private double signum;

    public LinearSolve(double[][] dArray) {
        this.N = dArray.length;
        if (this.N == 0) {
            throw new IllegalArgumentException("LinearSolve(): A is zero length");
        }
        this.LU = new double[this.N][this.N];
        for (int i = 0; i < this.N; ++i) {
            if (dArray[i].length != this.N) {
                throw new IllegalArgumentException("LinearSolve(): A is not a square matrix");
            }
            System.arraycopy(dArray[i], 0, this.LU[i], 0, this.N);
        }
        this.p = new int[this.N];
        this.signum = LinearSolve.luDecompose(this.LU, this.p, this.N);
    }

    public void solve(double[] dArray, double[] dArray2) {
        if (dArray.length != this.N) {
            throw new IllegalArgumentException("LinearSolve.solve(): x is not a " + this.N + "-element array");
        }
        if (dArray2.length != this.N) {
            throw new IllegalArgumentException("LinearSolve.solve(): b is not a " + this.N + "-element array");
        }
        for (int i = 0; i < this.N; ++i) {
            dArray[i] = dArray2[this.p[i]];
        }
        LinearSolve.luSolve(this.LU, this.p, dArray, this.N);
    }

    public void invert(double[][] dArray) {
        if (dArray.length != this.N) {
            throw new IllegalArgumentException("LinearSolve.invert(): Ainv is not a " + this.N + "-by-" + this.N + " matrix");
        }
        for (int i = 0; i < this.N; ++i) {
            if (dArray[i].length == this.N) continue;
            throw new IllegalArgumentException("LinearSolve.invert(): Ainv is not a " + this.N + "-by-" + this.N + " matrix");
        }
        double[] dArray2 = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            int n;
            for (n = 0; n < this.N; ++n) {
                dArray2[n] = i == this.p[n] ? 1.0 : 0.0;
            }
            LinearSolve.luSolve(this.LU, this.p, dArray2, this.N);
            for (n = 0; n < this.N; ++n) {
                dArray[n][i] = dArray2[n];
            }
        }
    }

    public void invertMultiply(double[][] dArray, double[][] dArray2) {
        if (dArray.length != this.N) {
            throw new IllegalArgumentException("LinearSolve.invertMultiply(): AinvB is not a " + this.N + "-by-" + this.N + " matrix");
        }
        if (dArray2.length != this.N) {
            throw new IllegalArgumentException("LinearSolve.invertMultiply(): B is not a " + this.N + "-by-" + this.N + " matrix");
        }
        for (int i = 0; i < this.N; ++i) {
            if (dArray[i].length != this.N) {
                throw new IllegalArgumentException("LinearSolve.invertMultiply(): AinvB is not a " + this.N + "-by-" + this.N + " matrix");
            }
            if (dArray2[i].length == this.N) continue;
            throw new IllegalArgumentException("LinearSolve.invertMultiply(): B is not a " + this.N + "-by-" + this.N + " matrix");
        }
        double[] dArray3 = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            int n;
            for (n = 0; n < this.N; ++n) {
                dArray3[n] = dArray2[this.p[n]][i];
            }
            LinearSolve.luSolve(this.LU, this.p, dArray3, this.N);
            for (n = 0; n < this.N; ++n) {
                dArray[n][i] = dArray3[n];
            }
        }
    }

    public double determinant() {
        double d = this.signum;
        for (int i = 0; i < this.N; ++i) {
            d *= this.LU[i][i];
        }
        return d;
    }

    private static double luDecompose(double[][] dArray, int[] nArray, int n) {
        int n2;
        double d = 1.0;
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = n2;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            double d2;
            double d3 = Math.abs(dArray[n2][n2]);
            int n3 = n2;
            for (int i = n2 + 1; i < n; ++i) {
                double d4 = Math.abs(dArray[i][n2]);
                if (!(d4 > d3)) continue;
                d3 = d4;
                n3 = i;
            }
            if (n3 != n2) {
                double[] dArray2 = dArray[n3];
                dArray[n3] = dArray[n2];
                dArray[n2] = dArray2;
                int n4 = nArray[n3];
                nArray[n3] = nArray[n2];
                nArray[n2] = n4;
                d = -d;
            }
            if ((d2 = dArray[n2][n2]) != 0.0) {
                for (int i = n2 + 1; i < n; ++i) {
                    double d5;
                    dArray[i][n2] = d5 = dArray[i][n2] / d2;
                    for (int j = n2 + 1; j < n; ++j) {
                        double[] dArray3 = dArray[i];
                        int n5 = j;
                        dArray3[n5] = dArray3[n5] - d5 * dArray[n2][j];
                    }
                }
                continue;
            }
            throw new DomainException("LinearSolve(): Zero pivot encountered");
        }
        return d;
    }

    private static void luSolve(double[][] dArray, int[] nArray, double[] dArray2, int n) {
        int n2;
        double d;
        int n3;
        for (n3 = 1; n3 < n; ++n3) {
            d = dArray2[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                d -= dArray[n3][n2] * dArray2[n2];
            }
            dArray2[n3] = d;
        }
        int n4 = n - 1;
        dArray2[n4] = dArray2[n4] / dArray[n - 1][n - 1];
        for (n3 = n - 2; n3 >= 0; --n3) {
            d = dArray2[n3];
            for (n2 = n3 + 1; n2 < n; ++n2) {
                d -= dArray[n3][n2] * dArray2[n2];
            }
            dArray2[n3] = d / dArray[n3][n3];
        }
    }
}

