/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.DomainException;

public class Cubic {
    private static final double TWO_PI = Math.PI * 2;
    private static final double FOUR_PI = Math.PI * 4;
    public int nRoots;
    public double x1;
    public double x2;
    public double x3;

    public void solve(double d, double d2, double d3, double d4) {
        if (d == 0.0) {
            throw new DomainException("Cubic.solve(): a = 0");
        }
        double d5 = d;
        d = d2 / d5;
        d2 = d3 / d5;
        d3 = d4 / d5;
        double d6 = d / 3.0;
        double d7 = (3.0 * d2 - d * d) / 9.0;
        double d8 = d7 * d7 * d7;
        double d9 = (9.0 * d * d2 - 27.0 * d3 - 2.0 * d * d * d) / 54.0;
        double d10 = d9 * d9;
        double d11 = d8 + d10;
        if (d11 < 0.0) {
            this.nRoots = 3;
            double d12 = Math.acos(d9 / Math.sqrt(-d8));
            double d13 = Math.sqrt(-d7);
            this.x1 = 2.0 * d13 * Math.cos(d12 / 3.0) - d6;
            this.x2 = 2.0 * d13 * Math.cos((d12 + Math.PI * 2) / 3.0) - d6;
            this.x3 = 2.0 * d13 * Math.cos((d12 + Math.PI * 4) / 3.0) - d6;
            this.sortRoots();
        } else if (d11 > 0.0) {
            this.nRoots = 1;
            double d14 = Math.sqrt(d11);
            double d15 = Math.cbrt(d9 + d14);
            double d16 = Math.cbrt(d9 - d14);
            this.x1 = d15 + d16 - d6;
            this.x2 = Double.NaN;
            this.x3 = Double.NaN;
        } else {
            this.nRoots = 3;
            double d17 = Math.cbrt(d9);
            this.x1 = 2.0 * d17 - d6;
            this.x2 = this.x3 = d17 - d6;
            this.sortRoots();
        }
    }

    private void sortRoots() {
        double d;
        if (this.x1 < this.x2) {
            d = this.x1;
            this.x1 = this.x2;
            this.x2 = d;
        }
        if (this.x2 < this.x3) {
            d = this.x2;
            this.x2 = this.x3;
            this.x3 = d;
        }
        if (this.x1 < this.x2) {
            d = this.x1;
            this.x1 = this.x2;
            this.x2 = d;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 4) {
            Cubic.usage();
        }
        double d = Double.parseDouble(stringArray[0]);
        double d2 = Double.parseDouble(stringArray[1]);
        double d3 = Double.parseDouble(stringArray[2]);
        double d4 = Double.parseDouble(stringArray[3]);
        Cubic cubic = new Cubic();
        cubic.solve(d, d2, d3, d4);
        System.out.println("x1 = " + cubic.x1);
        if (cubic.nRoots == 3) {
            System.out.println("x2 = " + cubic.x2);
            System.out.println("x3 = " + cubic.x3);
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.numeric.Cubic <a> <b> <c> <d>");
        System.err.println("Solves ax^3 + bx^2 + cx + d = 0");
        System.exit(1);
    }
}

